/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.jmx;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import net.sourceforge.cruisecontrol.CruiseControlConfig;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.PluginDetail;
import net.sourceforge.cruisecontrol.PluginRegistry;
import net.sourceforge.cruisecontrol.PluginType;
import net.sourceforge.cruisecontrol.ProjectConfig;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.jmx.CruiseControlControllerJMXAdaptorMBean;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.threadpool.ThreadQueue;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CruiseControlControllerJMXAdaptor
extends NotificationBroadcasterSupport
implements CruiseControlControllerJMXAdaptorMBean,
CruiseControlController.Listener {
    private static final Logger LOG = Logger.getLogger(CruiseControlControllerJMXAdaptor.class);
    private static final Object SEQUENCE_LOCK = new Object();
    private static int sequence = 0;
    private final CruiseControlController controller;
    private ObjectName registeredName;
    private MBeanServer server;

    public CruiseControlControllerJMXAdaptor(CruiseControlController controlController) {
        this.controller = controlController;
        this.controller.addListener(this);
    }

    @Override
    public Properties getVersionProperties() {
        return this.controller.getVersionProperties();
    }

    @Override
    public String getConfigFileName() {
        return this.controller.getConfigFile() != null ? this.controller.getConfigFile().getAbsolutePath() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigFileContents() {
        File theConfigFile = this.controller.getConfigFile();
        if (theConfigFile == null) {
            return "";
        }
        StringBuffer theResults = new StringBuffer();
        try {
            BufferedReader theConfigFileReader = new BufferedReader(new FileReader(theConfigFile));
            try {
                theResults = new StringBuffer((int)theConfigFile.length());
                CruiseControlControllerJMXAdaptor.readConfigFileContents(theResults, theConfigFileReader);
            }
            finally {
                theConfigFileReader.close();
            }
        }
        catch (FileNotFoundException fne) {
            LOG.error((Object)"Configuration file not found", (Throwable)fne);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error reading config file for JMX", (Throwable)ioe);
        }
        return theResults.toString();
    }

    static void readConfigFileContents(StringBuffer theResults, BufferedReader theConfigFileReader) throws IOException {
        String theCurrentLine = theConfigFileReader.readLine();
        while (theCurrentLine != null) {
            theResults.append(theCurrentLine).append('\n');
            theCurrentLine = theConfigFileReader.readLine();
        }
    }

    @Override
    public void setConfigFileContents(String contents) throws CruiseControlException {
        File theConfigFile = this.controller.getConfigFile();
        if (theConfigFile == null) {
            return;
        }
        this.validateConfig(contents);
        try {
            Util.doMkDirs(theConfigFile);
            theConfigFile.createNewFile();
            IO.write(theConfigFile, contents);
        }
        catch (FileNotFoundException fne) {
            LOG.error((Object)"Configuration file not found", (Throwable)fne);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error storing config file for JMX", (Throwable)ioe);
        }
    }

    public void validateConfig(String contents) throws CruiseControlException {
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes());
        Element config = Util.loadRootElement(in);
        new CruiseControlConfig(config, this.controller);
    }

    @Override
    public void setConfigFileName(String fileName) throws InvalidAttributeValueException {
        try {
            this.controller.setConfigFile(fileName != null ? new File(fileName) : null);
        }
        catch (CruiseControlException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
    }

    @Override
    public List<ProjectInterface> getProjects() {
        return this.controller.getProjects();
    }

    public List<String> getBusyTasks() {
        return ThreadQueue.getBusyTaskNames();
    }

    public List<String> getIdleTasks() {
        return ThreadQueue.getIdleTaskNames();
    }

    @Override
    public PluginDetail[] getAvailableBootstrappers() {
        return this.controller.getAvailableBootstrappers();
    }

    @Override
    public PluginDetail[] getAvailablePublishers() {
        return this.controller.getAvailablePublishers();
    }

    @Override
    public PluginDetail[] getAvailableSourceControls() {
        return this.controller.getAvailableSourceControls();
    }

    @Override
    public PluginDetail[] getAvailablePlugins() {
        return this.controller.getAvailablePlugins();
    }

    @Override
    public PluginType[] getAvailablePluginTypes() {
        return this.controller.getAvailablePluginTypes();
    }

    @Override
    public PluginRegistry getPluginRegistry() {
        return this.controller.getPluginRegistry();
    }

    @Override
    public void resume() {
        this.controller.resume();
    }

    @Override
    public void pause() {
        this.controller.pause();
    }

    @Override
    public void reloadConfigFile() {
        this.controller.reloadConfigFile();
    }

    @Override
    public String getBuildQueueStatus() {
        return this.controller.getBuildQueueStatus();
    }

    @Override
    public void halt() {
        this.controller.halt();
    }

    public void register(MBeanServer server) throws JMException {
        this.server = server;
        this.registeredName = new ObjectName("CruiseControl Manager:id=unique");
        server.registerMBean(this, this.registeredName);
        this.updateProjectMBeans();
    }

    private void updateProjectMBeans() {
        LOG.debug((Object)"Updating project mbeans");
        if (this.server != null) {
            for (ProjectInterface project : this.controller.getProjects()) {
                this.projectAdded(project);
            }
        }
    }

    @Override
    public void projectAdded(ProjectInterface project) {
        try {
            project.register(this.server);
        }
        catch (JMException e) {
            LOG.error((Object)("Could not register project " + project.getName()), (Throwable)e);
        }
        String name = "CruiseControl Project:name=" + project.getName();
        LOG.debug((Object)("Adding project " + project.getName()));
        this.notifyChanged("projectAdded", name);
    }

    @Override
    public void projectRemoved(ProjectInterface project) {
        String name = "CruiseControl Project:name=" + project.getName();
        LOG.debug((Object)("Removing project " + name));
        try {
            ObjectName projectName = new ObjectName(name);
            this.server.unregisterMBean(projectName);
        }
        catch (InstanceNotFoundException noProblem) {
        }
        catch (MBeanRegistrationException noProblem) {
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Could not unregister project " + project.getName()), (Throwable)e);
        }
        this.notifyChanged("projectRemoved", name);
    }

    private void notifyChanged(String event, String data) {
        Notification notification = new Notification("cruisecontrol." + event + ".event", this.registeredName, this.nextSequence());
        notification.setUserData(data);
        this.sendNotification(notification);
        LOG.debug((Object)("Sent " + event + " event."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextSequence() {
        Object object = SEQUENCE_LOCK;
        synchronized (object) {
            return ++sequence;
        }
    }

    @Override
    public Map<String, String> getAllProjectsStatus() {
        HashMap<String, String> allStatus = new HashMap<String, String>();
        for (ProjectInterface projectInterface : this.getProjects()) {
            ProjectConfig projectConfig = (ProjectConfig)projectInterface;
            String projectName = projectConfig.getName();
            String status = projectConfig.getStatus();
            if (ProjectState.BUILDING.hasDescription(status)) {
                status = status + " since " + projectConfig.getBuildStartTime();
            } else if (projectConfig.isPaused()) {
                status = ProjectState.PAUSED.getName();
            }
            allStatus.put(projectName, status);
        }
        return allStatus;
    }
}

