/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.jmx;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Log;
import mx4j.log.Log4JLogger;
import mx4j.log.Logger;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.naming.NamingService;
import mx4j.tools.naming.NamingServiceMBean;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.jmx.CruiseControlControllerJMXAdaptor;
import net.sourceforge.cruisecontrol.jmx.DashboardController;
import net.sourceforge.cruisecontrol.jmx.LoggerController;

public class CruiseControlControllerAgent {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(CruiseControlControllerAgent.class);
    private static final String JNDI_NAME = "/jndi/jrmp";
    private final HttpAdaptor httpAdaptor = new HttpAdaptor();
    private final int httpPort;
    private NamingServiceMBean rmiRegistry;
    private JMXConnectorServer connectorServer;
    private final int connectorServerPort;
    private final String path;
    private final String user;
    private final String password;
    public static final String ARG_JMX_AGENTUTIL = "agentutil";

    public CruiseControlControllerAgent(CruiseControlController controller, int httpPort, int connectorServerPort, String user, String password, String xslPath, LOAD_JMX_AGENTUTIL enableJMXAgentUtility) {
        ObjectName name;
        this.httpPort = httpPort;
        this.connectorServerPort = connectorServerPort;
        this.path = xslPath;
        CruiseControlControllerJMXAdaptor controllerAdaptor = new CruiseControlControllerJMXAdaptor(controller);
        this.user = user;
        this.password = password;
        Log.redirectTo((Logger)new Log4JLogger());
        Iterator<MBeanServer> i = MBeanServerFactory.findMBeanServer(null).iterator();
        MBeanServer server = i.hasNext() ? i.next() : MBeanServerFactory.createMBeanServer();
        try {
            controllerAdaptor.register(server);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem registering CruiseControlController HttpAdaptor", (Throwable)e);
        }
        try {
            this.registerHttpAdaptor(server);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem registering HttpAdaptor", (Throwable)e);
        }
        try {
            this.registerConnectorServer(server);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem registering ConnectorServer", (Throwable)e);
        }
        try {
            name = new ObjectName("Logger:name=root");
            server.registerMBean(new LoggerController(org.apache.log4j.Logger.getRootLogger()), name);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem registering LoggerController for root-Logger", (Throwable)e);
        }
        try {
            name = new ObjectName("CruiseControl Dashboard:name=posting");
            server.registerMBean(new DashboardController(controller), name);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem registering DashboardController for posting", (Throwable)e);
        }
        if (LOAD_JMX_AGENTUTIL.FORCE_BYPASS != enableJMXAgentUtility) {
            try {
                String className = "net.sourceforge.cruisecontrol.jmx.JMXBuildAgentUtility";
                Class clsDistCCMBean = CruiseControlControllerAgent.loadDistCCMBeanClass(enableJMXAgentUtility, "net.sourceforge.cruisecontrol.jmx.JMXBuildAgentUtility");
                if (clsDistCCMBean != null) {
                    Object objDistCCMBean = clsDistCCMBean.getConstructor(null).newInstance(null);
                    ObjectName name2 = new ObjectName("CruiseControl Distributed:name=buildAgentUtility");
                    server.registerMBean(objDistCCMBean, name2);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Problem registering Build Agent Utility jmx bean", (Throwable)e);
            }
        }
    }

    private static Class loadDistCCMBeanClass(LOAD_JMX_AGENTUTIL enableJMXAgentUtility, String className) {
        Class<?> clsDistCCMBean = null;
        try {
            clsDistCCMBean = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String msgPrefix = "Failed to load JMX DistCC class: " + className;
            if (LOAD_JMX_AGENTUTIL.FORCE_LOAD == enableJMXAgentUtility) {
                LOG.error((Object)(msgPrefix + ". DistCC JMX classes are not on the classpath. \n" + "You need to include the contrib/distributed classes to use this feature. \n" + "Try using contrib/distributed/cruisecontrol[.bat][.sh]."));
            }
            LOG.debug((Object)msgPrefix);
        }
        return clsDistCCMBean;
    }

    public void start() {
        if (this.useHttpAdaptor()) {
            try {
                LOG.info((Object)"starting httpAdaptor");
                this.httpAdaptor.start();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception starting httpAdaptor", (Throwable)e);
            }
        }
        if (this.useConnectorServer()) {
            try {
                LOG.info((Object)"starting rmiRegistry");
                this.rmiRegistry.start();
            }
            catch (RemoteException e) {
                if (e.getMessage().startsWith("Port already in use")) {
                    LOG.warn((Object)("Port " + this.connectorServerPort + " is already in use, so no new rmiRegistry is started"));
                }
                LOG.error((Object)"Exception starting rmiRegistry", (Throwable)e);
            }
            try {
                LOG.info((Object)"starting connectorServer");
                this.connectorServer.start();
            }
            catch (Exception e) {
                if (e.getMessage().startsWith("javax.naming.NameAlreadyBoundException")) {
                    LOG.warn((Object)"Couldn't start connectorServer since its name (/jndi/jrmp) is already bound; you might need to restart your rmi registry");
                }
                LOG.error((Object)"Exception starting connectorServer", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.useHttpAdaptor() && this.httpAdaptor.isActive()) {
            this.httpAdaptor.stop();
        }
        if (this.useConnectorServer()) {
            if (this.connectorServer.isActive()) {
                try {
                    LOG.info((Object)"stopping connectorServer");
                    this.connectorServer.stop();
                }
                catch (IOException e) {
                    LOG.error((Object)"IOException stopping connectorServer", (Throwable)e);
                }
            }
            if (this.rmiRegistry.isRunning()) {
                try {
                    LOG.info((Object)"stopping rmiRegistry");
                    this.rmiRegistry.stop();
                }
                catch (NoSuchObjectException e) {
                    LOG.error((Object)"NoSuchObjectException stopping rmiRegistry", (Throwable)e);
                }
            }
        }
    }

    private void registerHttpAdaptor(MBeanServer server) throws Exception {
        if (this.useHttpAdaptor()) {
            this.httpAdaptor.setPort(this.httpPort);
            System.setProperty("cruisecontrol.jmxport", String.valueOf(this.httpPort));
            this.httpAdaptor.setHost("0.0.0.0");
            ObjectName adaptorName = new ObjectName("Adapter:name=HttpAdaptor,httpPort=" + this.httpPort);
            server.registerMBean(this.httpAdaptor, adaptorName);
            ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
            server.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", processorName, null);
            String pathInJar = "net/sourceforge/cruisecontrol/jmx/xsl";
            if (this.path != null && !this.path.equals("")) {
                LOG.info((Object)"Starting HttpAdaptor with customized Stylesheets");
                server.setAttribute(processorName, new Attribute("File", this.path));
            } else {
                LOG.info((Object)"Starting HttpAdaptor with CC-Stylesheets");
                server.setAttribute(processorName, new Attribute("PathInJar", pathInJar));
            }
            server.setAttribute(adaptorName, new Attribute("ProcessorName", processorName));
            if (this.user != null && this.password != null) {
                LOG.info((Object)"This CruiseControl instance is password protected");
                this.httpAdaptor.setAuthenticationMethod("basic");
                this.httpAdaptor.addAuthorization(this.user, this.password);
                System.setProperty("jmx.http.username", this.user);
                System.setProperty("jmx.http.password", this.password);
            }
        }
    }

    private boolean useHttpAdaptor() {
        return this.httpPort != -1;
    }

    private void registerConnectorServer(MBeanServer server) throws Exception {
        if (this.useConnectorServer()) {
            ObjectName naming = new ObjectName("Naming:type=rmiregistry");
            this.rmiRegistry = new NamingService(this.connectorServerPort);
            server.registerMBean(this.rmiRegistry, naming);
            System.setProperty("cruisecontrol.rmiport", String.valueOf(this.connectorServerPort));
            JMXServiceURL address = new JMXServiceURL("rmi", "localhost", 0, JNDI_NAME);
            HashMap<String, String> environment = new HashMap<String, String>();
            String registryContextFactory = "com.sun.jndi.rmi.registry.RegistryContextFactory";
            environment.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            environment.put("java.naming.provider.url", "rmi://localhost:" + this.connectorServerPort);
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(address, environment, server);
            ObjectName connServerName = new ObjectName("ConnectorServer:name=/jndi/jrmp");
            server.registerMBean(this.connectorServer, connServerName);
        }
    }

    private boolean useConnectorServer() {
        return this.connectorServerPort != -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOAD_JMX_AGENTUTIL {
        LOAD_IF_AVAILABLE,
        FORCE_LOAD,
        FORCE_BYPASS;

    }
}

