/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.ProjectXMLHelper;
import net.sourceforge.cruisecontrol.config.PropertiesPlugin;
import net.sourceforge.cruisecontrol.util.OSEnvironment;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertiesPlugin
implements PropertiesPlugin {
    private String file;
    private String environment;
    private String name;
    private String value;
    private String toupper;

    public void setName(String name) {
        this.name = name;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setToupper(String toupper) {
        this.toupper = toupper;
    }

    public void validate() throws CruiseControlException {
        if (this.name == null && this.file == null && this.environment == null) {
            ValidationHelper.fail("At least one of name, file or environment must be set.");
        }
        if (this.name != null && (this.file != null || this.environment != null) || this.file != null && this.environment != null) {
            ValidationHelper.fail("At most one of name, file or environment can be set.");
        }
        if (this.file == null || this.file.trim().length() > 0) {
            // empty if block
        }
        if (this.name != null && this.value == null) {
            ValidationHelper.fail("name and value must be set simultaneoulsy.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties(Map<String, String> props, boolean failIfMissing) throws CruiseControlException {
        block13: {
            boolean toUpperValue = "true".equals(this.toupper);
            if (this.file != null && this.file.trim().length() > 0) {
                File theFile = new File(this.file);
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(theFile));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int index;
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || (index = line.indexOf(61)) < 0) continue;
                            String parsedName = Util.parsePropertiesInString(props, line.substring(0, index).trim(), failIfMissing);
                            String parsedValue = Util.parsePropertiesInString(props, line.substring(index + 1).trim(), failIfMissing);
                            ProjectXMLHelper.setProperty(props, parsedName, parsedValue);
                        }
                        break block13;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new CruiseControlException("Could not load properties from theFile \"" + this.file + "\". The theFile does not exist", e);
                }
                catch (IOException e) {
                    throw new CruiseControlException("Could not load properties from theFile \"" + this.file + "\".", e);
                }
            }
            if (this.environment != null) {
                for (String line : new OSEnvironment().getEnvironment()) {
                    int index = line.indexOf(61);
                    if (index < 0) continue;
                    StringBuilder propName = new StringBuilder(this.environment);
                    propName.append(".");
                    if (toUpperValue) {
                        propName.append(line.substring(0, index).toUpperCase());
                    } else {
                        propName.append(line.substring(0, index));
                    }
                    String parsedValue = Util.parsePropertiesInString(props, line.substring(index + 1), failIfMissing);
                    ProjectXMLHelper.setProperty(props, propName.toString(), parsedValue);
                }
            } else {
                String parsedValue = Util.parsePropertiesInString(props, this.value, failIfMissing);
                ProjectXMLHelper.setProperty(props, this.name, parsedValue);
            }
        }
    }
}

