/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.buildloggers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.cruisecontrol.BuildLogger;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.Processes;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class ClearCaseAuditLogger
implements BuildLogger {
    private static final Logger LOG = Logger.getLogger(ClearCaseAuditLogger.class);
    private String doFiles;

    public void setDoFiles(String files) {
        this.doFiles = files;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.doFiles, "dofiles", this.getClass());
    }

    public void log(Element buildLog) throws CruiseControlException {
        String[] doList = this.splitOnComma(this.doFiles);
        for (int i = 0; i < doList.length; ++i) {
            Element auditElement = new Element("audit");
            auditElement.setAttribute("name", doList[i]);
            buildLog.addContent((Content)auditElement);
            Commandline commandLine = this.buildConfigRecCommand(doList[i]);
            LOG.debug((Object)("Executing: " + commandLine));
            try {
                Process p = Processes.execute(commandLine);
                try {
                    String line;
                    InputStreamReader isr = new InputStreamReader(p.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("---") || line.startsWith("MVFS")) continue;
                        Element doElement = new Element("do");
                        if ((line = line.substring(line.indexOf(File.separator), line.length())).indexOf("@") > 0) {
                            doElement.setAttribute("name", line.substring(0, line.indexOf("@")));
                        } else {
                            doElement.setAttribute("name", line.substring(0, line.indexOf("<") - 1));
                        }
                        if (line.endsWith(">")) {
                            doElement.setAttribute("type", "version");
                            if (line.indexOf("@") > 0) {
                                doElement.setAttribute("version", line.substring(line.indexOf("@") + 2, line.lastIndexOf("<") - 1));
                            } else {
                                doElement.setAttribute("version", line.substring(line.indexOf("<") + 1, line.lastIndexOf(">") - 1));
                            }
                        } else {
                            doElement.setAttribute("type", "do");
                            doElement.setAttribute("version", line.substring(line.indexOf("@") + 2, line.length()));
                        }
                        auditElement.addContent((Content)doElement);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error executing ClearCase catcr command", (Throwable)ioe);
                }
                p.waitFor();
                IO.close(p);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Error executing ClearCase catcr command", (Throwable)e);
            }
        }
    }

    private String[] splitOnComma(String doFiles) {
        return doFiles.split(",");
    }

    protected Commandline buildConfigRecCommand(String file) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArgument("catcr");
        commandLine.createArgument("-union");
        commandLine.createArgument(file);
        return commandLine;
    }
}

