/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.BuildOutputLoggerManager;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.BuildOutputLogger;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.Directory;
import net.sourceforge.cruisecontrol.util.Util;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcodeBuilder
extends Builder
implements Script {
    private static final Logger LOG = Logger.getLogger(XcodeBuilder.class);
    private static final String DEFAULT_OUTFILE_NAME = "xcodebuild.cc.output";
    Directory directory = new Directory();
    private int exitCode = -1;
    private boolean hitBuildFailedMessage;
    private long timeout = -1L;
    private boolean buildTimedOut;
    private Arguments arguments = new Arguments();
    private Map<String, String> buildProperties;

    @Override
    public Element build(Map<String, String> properties, Progress progress) throws CruiseControlException {
        this.setProperties(properties);
        OutputFile file = this.createOutputFile(this.directory, DEFAULT_OUTFILE_NAME);
        this.runScript(file);
        return this.elementFromFile(file);
    }

    void setProperties(Map<String, String> properties) {
        this.buildProperties = properties;
    }

    private void runScript(OutputFile file) throws CruiseControlException {
        LOG.info((Object)"starting build");
        boolean finished = this.createScriptRunner().runScript(this, this.timeout, file.getBuildOutputLogger());
        this.buildTimedOut = !finished;
        LOG.info((Object)("build finished with exit code " + this.exitCode));
    }

    ScriptRunner createScriptRunner() {
        return new ScriptRunner();
    }

    OutputFile createOutputFile(Directory d, String filename) {
        return new OutputFile(d, filename);
    }

    Element elementFromFile(OutputFile file) {
        this.hitBuildFailedMessage = false;
        Element build = new Element("build");
        while (file.hasMoreLines()) {
            String line = file.nextLine();
            Element message = this.getElementFromLine(line);
            if (message == null) continue;
            build.addContent((Content)message);
        }
        if (this.hitBuildFailedMessage) {
            build.setAttribute("error", "** BUILD FAILED **");
        } else if (this.timeout != -1L && this.buildTimedOut) {
            build.setAttribute("error", "build timed out");
        }
        return build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String target, Progress progress) throws CruiseControlException {
        this.arguments.overrideTarget(target);
        try {
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.arguments.resetTarget();
        }
    }

    @Override
    public void validate() throws CruiseControlException {
        LOG.debug((Object)"super.validate()");
        super.validate();
        LOG.debug((Object)"validate directory");
        this.directory.validate();
        LOG.debug((Object)"validate args");
        this.arguments.validate();
    }

    @Override
    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        cmdLine.setWorkingDir(this.directory);
        cmdLine.setExecutable("xcodebuild");
        this.arguments.addArguments(cmdLine, this.buildProperties);
        return cmdLine;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int result) {
        LOG.debug((Object)("exit code set to " + result));
        this.exitCode = result;
    }

    public void setDirectory(String path) {
        this.directory.setPath(path);
    }

    public Element getElementFromLine(String line) {
        if (this.hitBuildFailedMessage) {
            return this.messageAtLevel(line, "error");
        }
        Element e = this.messageAtLevelIfContains(line, "warn", " warning: ");
        if (e != null) {
            return e;
        }
        e = this.messageAtLevelIfContains(line, "error", " error: ");
        if (e != null) {
            return e;
        }
        e = this.messageAtLevelIfContains(line, "error", "** BUILD FAILED **");
        if (e != null) {
            this.hitBuildFailedMessage = true;
            return e;
        }
        return null;
    }

    private Element messageAtLevelIfContains(String line, String messageLevel, String semaphore) {
        if (line.contains(semaphore)) {
            return this.messageAtLevel(line, messageLevel);
        }
        return null;
    }

    private Element messageAtLevel(String line, String messageLevel) {
        Element target = new Element("target");
        Element task = new Element("task");
        target.addContent((Content)task);
        Element message = new Element("message");
        task.addContent((Content)message);
        message.setAttribute("priority", messageLevel);
        message.setText(line);
        return target;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Arg createArg() {
        return this.arguments.createArg();
    }

    public class Arg {
        String value;

        public void setValue(String value) {
            this.value = value.trim();
        }

        public void validate() throws InvalidValueException {
            if (this.value.length() == 0) {
                throw new InvalidValueException();
            }
        }

        class InvalidValueException
        extends CruiseControlException {
            InvalidValueException() {
                super("value of arg can't be an empty string");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Arguments {
        private List<Arg> args = new ArrayList<Arg>();
        private Arg overrideTarget;
        private Arg originalTarget;

        Arguments() {
        }

        public Arg createArg() {
            Arg arg = new Arg();
            this.args.add(arg);
            return arg;
        }

        public void resetTarget() {
            this.args.remove(this.overrideTarget);
            if (this.originalTarget != null) {
                this.args.add(this.originalTarget);
                this.originalTarget = null;
            }
        }

        public void overrideTarget(String string) {
            this.saveOriginalTarget();
            this.overrideTarget = this.createArg();
            this.overrideTarget.setValue("-target " + string);
        }

        private void saveOriginalTarget() {
            for (Arg arg : this.args) {
                if (!arg.value.startsWith("-target ")) continue;
                this.originalTarget = arg;
                this.args.remove(arg);
                break;
            }
        }

        public void validate() throws CruiseControlException {
            for (Arg arg : this.args) {
                arg.validate();
            }
        }

        public void addArguments(Commandline cmdLine, Map<String, String> buildProperties) {
            for (Arg arg : this.args) {
                String value = this.substituteProperties(buildProperties, arg.value);
                cmdLine.createArgument().setValue(value);
            }
        }

        private String substituteProperties(Map properties, String string) {
            String value = string;
            try {
                value = Util.parsePropertiesInString(properties, string, false);
            }
            catch (CruiseControlException e) {
                LOG.error((Object)("exception substituting properties into arguments: " + string), (Throwable)e);
            }
            return value;
        }
    }

    static class OutputFile {
        private File file;
        private BufferedReader reader;
        private String nextLine;

        OutputFile(Directory dir, String filename) {
            this.file = new File(dir.toFile(), filename);
        }

        public String nextLine() {
            return this.nextLine;
        }

        public boolean hasMoreLines() {
            if (this.reader == null) {
                this.createReader();
            }
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (IOException e) {
                LOG.error((Object)("error reading file " + this.file.getAbsolutePath()), (Throwable)e);
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException(e);
            }
            if (this.nextLine != null) {
                return true;
            }
            LOG.debug((Object)"reached end of build output");
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private void createReader() {
            LOG.debug((Object)("creating reader for file " + this.file.getAbsolutePath()));
            try {
                this.reader = new BufferedReader(new FileReader(this.file));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("error creating reader for file " + this.file.getAbsolutePath()), (Throwable)e);
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException(e);
            }
        }

        private BuildOutputLogger getBuildOutputLogger() {
            BuildOutputLogger logger = BuildOutputLoggerManager.INSTANCE.lookupOrCreate(this.file);
            logger.clear();
            return logger;
        }
    }
}

