/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.BuildOutputLogger;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.CompositeConsumer;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Logger;

public class ScriptRunner {
    private static final Logger LOG = Logger.getLogger(ScriptRunner.class);
    public static final long NO_TIMEOUT = -1L;

    public boolean runScript(File workingDir, Script script, long timeout) throws CruiseControlException {
        return this.runScript(workingDir, script, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runScript(File workingDir, Script script, long timeout, BuildOutputLogger buildOutputConsumer) throws CruiseControlException {
        Process p;
        Commandline commandline = script.buildCommandline();
        if (workingDir != null) {
            commandline.setWorkingDir(workingDir);
        }
        if (buildOutputConsumer != null) {
            buildOutputConsumer.clear();
        }
        try {
            p = commandline.execute();
        }
        catch (IOException e) {
            throw new CruiseControlException("Encountered an IO exception while attempting to execute '" + script.toString() + "'. CruiseControl cannot continue.", e);
        }
        CompositeConsumer consumerForError = new CompositeConsumer(StreamLogger.getWarnLogger(LOG));
        CompositeConsumer consumerForOut = new CompositeConsumer(StreamLogger.getInfoLogger(LOG));
        if (buildOutputConsumer != null) {
            consumerForError.add(buildOutputConsumer);
            consumerForOut.add(buildOutputConsumer);
        }
        if (script instanceof StreamConsumer) {
            consumerForError.add((StreamConsumer)((Object)script));
            consumerForOut.add((StreamConsumer)((Object)script));
        }
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), consumerForError);
        StreamPumper outPumper = new StreamPumper(p.getInputStream(), consumerForOut);
        Thread stderr = new Thread(errorPumper);
        stderr.start();
        Thread stdout = new Thread(outPumper);
        stdout.start();
        AsyncKiller killer = new AsyncKiller(p, timeout);
        if (timeout > 0L) {
            killer.start();
        }
        int exitCode = -1;
        try {
            exitCode = p.waitFor();
            killer.interrupt();
            stderr.join();
            stdout.join();
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Was interrupted while waiting for script to finish. CruiseControl will continue, assuming that it completed");
        }
        finally {
            IO.close(p);
        }
        script.setExitCode(exitCode);
        return !killer.processKilled();
    }

    public boolean runScript(Script script, long timeout, BuildOutputLogger logger) throws CruiseControlException {
        return this.runScript(null, script, timeout, logger);
    }

    public static class AsyncKiller
    extends Thread {
        private final Process p;
        private final long timeout;
        private boolean killed;

        AsyncKiller(Process p, long timeout) {
            this.p = p;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AsyncKiller.sleep(this.timeout * 1000L);
                AsyncKiller asyncKiller = this;
                synchronized (asyncKiller) {
                    this.p.destroy();
                    this.killed = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized boolean processKilled() {
            return this.killed;
        }
    }
}

