/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class RakeScript
implements Script,
StreamConsumer {
    private boolean isWindows;
    private String buildFile = null;
    private String target = "";
    private Progress progress;
    private int exitCode;
    private Element buildLogElement;

    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        if (this.isWindows) {
            cmdLine.setExecutable("cmd");
            cmdLine.createArgument().setValue("/c");
            cmdLine.createArgument().setValue("rake");
        } else {
            cmdLine.setExecutable("rake");
        }
        if (this.buildFile != null) {
            cmdLine.createArgument().setValue("-f");
            cmdLine.createArgument().setValue(this.buildFile);
        }
        StringTokenizer targets = new StringTokenizer(this.target);
        while (targets.hasMoreTokens()) {
            cmdLine.createArgument().setValue(targets.nextToken());
        }
        return cmdLine;
    }

    public void setBuildLogHeader(Element buildLogElement) {
        this.buildLogElement = buildLogElement;
    }

    public void setWindows(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumeLine(String line) {
        if (line == null || line.length() == 0 || this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (line.startsWith("rake aborted!")) {
                this.buildLogElement.setAttribute("error", "BUILD FAILED detected");
            } else {
                Element msg = new Element("message");
                msg.addContent((Content)new CDATA(line));
                msg.setAttribute("priority", "info");
                this.buildLogElement.addContent((Content)msg);
            }
            if (this.progress != null) {
                this.progress.setValue(line);
            }
        }
    }
}

