/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhingScript
implements Script {
    private Map<String, String> buildProperties;
    private String phingScript;
    private String loggerClassName;
    private String tempFileName = "log.xml";
    private boolean useLogger;
    private boolean useQuiet;
    private boolean useDebug;
    private String buildFile = "build.xml";
    private List<Property> properties;
    private String target = "";
    private int exitCode;

    @Override
    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(this.phingScript);
        if (this.useLogger) {
            cmdLine.createArguments("-logger", this.getLoggerClassName());
            cmdLine.createArguments("-logfile", this.tempFileName);
        } else {
            cmdLine.createArguments("-listener", this.getLoggerClassName());
            cmdLine.createArgument("-DXmlLogger.file=" + this.tempFileName);
        }
        if (this.useDebug) {
            cmdLine.createArgument("-debug");
        } else if (this.useQuiet) {
            cmdLine.createArgument("-quiet");
        }
        for (Map.Entry<String, String> entry : this.buildProperties.entrySet()) {
            String value = entry.getValue();
            if ("".equals(value)) continue;
            cmdLine.createArgument("-D" + entry.getKey() + "=" + value);
        }
        for (Property property : this.properties) {
            cmdLine.createArgument("-D" + property.getName() + "=" + property.getValue());
        }
        cmdLine.createArguments("-buildfile", this.buildFile);
        StringTokenizer targets = new StringTokenizer(this.target);
        while (targets.hasMoreTokens()) {
            cmdLine.createArgument(targets.nextToken());
        }
        System.out.println(cmdLine.toString());
        return cmdLine;
    }

    public void setBuildProperties(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String loggerClassName) {
        this.loggerClassName = loggerClassName;
    }

    public void setPhingScript(String antScript) {
        this.phingScript = antScript;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setUseDebug(boolean useDebug) {
        this.useDebug = useDebug;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void setUseQuiet(boolean useQuiet) {
        this.useQuiet = useQuiet;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

