/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.PhingScript;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.EmptyElementFilter;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhingBuilder
extends Builder {
    protected static final String DEFAULT_LOGGER = "phing.listener.XmlLogger";
    private static final Logger LOG = Logger.getLogger(PhingBuilder.class);
    private String phingWorkingDir = null;
    private String buildFile = "build.xml";
    private String target = "";
    private String tempFileName = "log.xml";
    private String phingScript = "phing";
    private String phingHome;
    private boolean useLogger;
    private final List<Property> properties = new ArrayList<Property>();
    private boolean useDebug = false;
    private boolean useQuiet = false;
    private String loggerClassName = "phing.listener.XmlLogger";
    private File saveLogDir = null;
    private long timeout = -1L;
    private boolean wasValidated = false;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.buildFile, "buildfile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.target, "target", this.getClass());
        ValidationHelper.assertFalse(this.useDebug && this.useQuiet, "'useDebug' and 'useQuiet' can't be used together");
        if (!this.useLogger && (this.useDebug || this.useQuiet)) {
            LOG.warn((Object)"usedebug and usequiet are ignored if uselogger is not set to 'true'!");
        }
        if (this.saveLogDir != null) {
            ValidationHelper.assertTrue(this.saveLogDir.isDirectory(), "'saveLogDir' must exist and be a directory");
        }
        if (this.phingHome != null) {
            File phingHomeFile = new File(this.phingHome);
            ValidationHelper.assertTrue(phingHomeFile.exists() && phingHomeFile.isDirectory(), "'phingHome' must exist and be a directory. Expected to find " + phingHomeFile.getAbsolutePath());
            File phingScriptInPhingHome = new File(this.findPhingScript(Util.isWindows()));
            ValidationHelper.assertTrue(phingScriptInPhingHome.exists() && phingScriptInPhingHome.isFile(), "'phingHome' must contain an ant execution script. Expected to find " + phingScriptInPhingHome.getAbsolutePath());
            this.phingScript = phingScriptInPhingHome.getAbsolutePath();
        }
        this.wasValidated = true;
    }

    @Override
    public Element build(Map<String, String> buildProperties, Progress progress) throws CruiseControlException {
        Element buildLogElement;
        if (!this.wasValidated) {
            throw new IllegalStateException("This builder was never validated. The build method should not be getting called.");
        }
        this.validateBuildFileExists();
        PhingScript script = new PhingScript();
        script.setBuildProperties(buildProperties);
        script.setProperties(this.properties);
        script.setUseLogger(this.useLogger);
        script.setPhingScript(this.phingScript);
        script.setBuildFile(this.buildFile);
        script.setTarget(this.target);
        script.setLoggerClassName(this.loggerClassName);
        script.setTempFileName(this.tempFileName);
        script.setUseDebug(this.useDebug);
        script.setUseQuiet(this.useQuiet);
        File workingDir = this.phingWorkingDir != null ? new File(this.phingWorkingDir) : null;
        boolean scriptCompleted = new ScriptRunner().runScript(workingDir, script, this.timeout);
        File logFile = new File(this.phingWorkingDir, this.tempFileName);
        if (!scriptCompleted) {
            LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
            buildLogElement = new Element("build");
            buildLogElement.setAttribute("error", "build timeout");
            if (logFile.exists()) {
                try {
                    buildLogElement.setText(Util.readFileToString(logFile));
                }
                catch (IOException likely) {}
            }
        } else {
            buildLogElement = PhingBuilder.getPhingLogAsElement(logFile);
            this.savePhingLog(logFile);
            logFile.delete();
        }
        return buildLogElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String buildTarget, Progress progress) throws CruiseControlException {
        String origTarget = this.target;
        try {
            this.target = buildTarget;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.target = origTarget;
        }
    }

    void validateBuildFileExists() throws CruiseControlException {
        File build = new File(this.buildFile);
        if (!build.isAbsolute() && this.phingWorkingDir != null) {
            build = new File(this.phingWorkingDir, this.buildFile);
        }
        ValidationHelper.assertExists(build, "buildfile", this.getClass());
    }

    public void setSaveLogDir(String dir) {
        this.saveLogDir = null;
        if (dir != null && !dir.trim().equals("")) {
            this.saveLogDir = new File(dir.trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void savePhingLog(File logFile) {
        if (this.saveLogDir == null) {
            return;
        }
        try {
            File newPhingLogFile = new File(this.saveLogDir, this.tempFileName);
            newPhingLogFile.createNewFile();
            FileInputStream in = new FileInputStream(logFile);
            try {
                FileOutputStream out = new FileOutputStream(newPhingLogFile);
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            LOG.error((Object)("Unable to create file: " + new File(this.saveLogDir, this.tempFileName)));
        }
    }

    public void setPhingWorkingDir(String dir) {
        this.phingWorkingDir = dir;
    }

    public void setPhingScript(String phingScript) {
        this.phingScript = phingScript;
    }

    public void setPhingHome(String antHome) {
        this.phingHome = antHome;
    }

    protected String findPhingScript(boolean isWindows) throws CruiseControlException {
        if (this.phingHome == null) {
            throw new CruiseControlException("phinghome attribute not set.");
        }
        if (isWindows) {
            return this.phingHome + "\\bin\\phing.bat";
        }
        return this.phingHome + "/bin/phing";
    }

    public void setTempFile(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public Property createProperty() {
        Property property = new Property();
        this.properties.add(property);
        return property;
    }

    protected static Element getPhingLogAsElement(File file) throws CruiseControlException {
        if (!file.exists()) {
            throw new CruiseControlException("phing logfile " + file.getAbsolutePath() + " does not exist.");
        }
        if (file.length() == 0L) {
            throw new CruiseControlException("phing logfile " + file.getAbsolutePath() + " is empty. Your build probably failed. Check your CruiseControl logs.");
        }
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            XMLFilterImpl piFilter = new XMLFilterImpl(){

                public void processingInstruction(String target, String data) throws SAXException {
                    if (target.equals("xml:stylesheet")) {
                        target = "xml-stylesheet";
                    }
                    super.processingInstruction(target, data);
                }
            };
            EmptyElementFilter emptyTaskFilter = new EmptyElementFilter("task");
            emptyTaskFilter.setParent(piFilter);
            EmptyElementFilter emptyMessageFilter = new EmptyElementFilter("message");
            emptyMessageFilter.setParent(emptyTaskFilter);
            builder.setXMLFilter((XMLFilter)emptyMessageFilter);
            return builder.build(file).getRootElement();
        }
        catch (Exception ee) {
            if (ee instanceof CruiseControlException) {
                throw (CruiseControlException)ee;
            }
            File saveFile = new File(file.getParentFile(), System.currentTimeMillis() + file.getName());
            file.renameTo(saveFile);
            throw new CruiseControlException("Error reading : " + file.getAbsolutePath() + ".  Saved as : " + saveFile.getAbsolutePath(), ee);
        }
    }

    public void setUseDebug(boolean debug) {
        this.useDebug = debug;
    }

    public void setUseQuiet(boolean quiet) {
        this.useQuiet = quiet;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String string) {
        this.loggerClassName = string;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

