/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NantScript
implements Script {
    private Map<String, String> buildProperties;
    private List<Property> nantProperties;
    private String loggerClassName;
    private String tempFileName = "log.xml";
    private boolean useLogger;
    private boolean useQuiet;
    private boolean useDebug;
    private String buildFile = "default.build";
    private String target = "";
    private String targetFramework;
    private int exitCode;

    @Override
    public Commandline buildCommandline() {
        Commandline cmdLine = this.getCommandLine();
        cmdLine.setExecutable("NAnt.exe");
        if (this.useLogger) {
            cmdLine.createArgument("-logger:" + this.getLoggerClassName());
            cmdLine.createArgument("-logfile:" + this.tempFileName);
        } else {
            cmdLine.createArgument("-listener:" + this.getLoggerClassName());
            cmdLine.createArgument("-D:XmlLogger.file=" + this.tempFileName);
        }
        if (this.useDebug) {
            cmdLine.createArgument("-debug+");
        } else if (this.useQuiet) {
            cmdLine.createArgument("-quiet+");
        }
        if (this.targetFramework != null) {
            cmdLine.createArgument("-t:" + this.targetFramework);
        }
        for (Map.Entry<String, String> entry : this.buildProperties.entrySet()) {
            String value = entry.getValue();
            if ("".equals(value)) continue;
            cmdLine.createArgument("-D:" + entry.getKey() + "=" + value);
        }
        for (Property property : this.nantProperties) {
            cmdLine.createArgument("-D:" + property.getName() + "=" + property.getValue());
        }
        cmdLine.createArgument("-buildfile:" + this.buildFile);
        StringTokenizer targets = new StringTokenizer(this.target);
        while (targets.hasMoreTokens()) {
            cmdLine.createArgument(targets.nextToken());
        }
        return cmdLine;
    }

    protected Commandline getCommandLine() {
        return new Commandline();
    }

    public void setBuildProperties(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setNantProperties(List<Property> properties) {
        this.nantProperties = properties;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String loggerClassName) {
        this.loggerClassName = loggerClassName;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setUseDebug(boolean useDebug) {
        this.useDebug = useDebug;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void setUseQuiet(boolean useQuiet) {
        this.useQuiet = useQuiet;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetFramework(String targetFramework) {
        this.targetFramework = targetFramework;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

