/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.NantScript;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.EmptyElementFilter;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Element;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.xml.sax.XMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NantBuilder
extends Builder {
    protected static final String DEFAULT_LOGGER = "NAnt.Core.XmlLogger";
    private static final Logger LOG = Logger.getLogger(NantBuilder.class);
    private String nantWorkingDir = null;
    private String buildFile = "default.build";
    private String target = "";
    private String tempFileName = "log.xml";
    private boolean useLogger;
    private final List<Property> properties = new ArrayList<Property>();
    private boolean useDebug = false;
    private boolean useQuiet = false;
    private String loggerClassName = "NAnt.Core.XmlLogger";
    private File saveLogDir = null;
    private String targetFramework = null;
    private long timeout = -1L;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.buildFile, "buildFile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.target, "target", this.getClass());
        ValidationHelper.assertFalse(this.useDebug && this.useQuiet, "'useDebug' and 'useQuiet' can't be used together");
        if (this.saveLogDir != null) {
            ValidationHelper.assertTrue(this.saveLogDir.isDirectory(), "'saveLogDir' must exist and be a directory");
        }
    }

    @Override
    public Element build(Map<String, String> buildProperties, Progress progress) throws CruiseControlException {
        Element buildLogElement;
        File workingDir = this.nantWorkingDir != null ? new File(this.nantWorkingDir) : null;
        NantScript script = this.getNantScript();
        script.setBuildFile(this.buildFile);
        script.setBuildProperties(buildProperties);
        script.setNantProperties(this.properties);
        script.setLoggerClassName(this.loggerClassName);
        script.setTarget(this.target);
        script.setTargetFramework(this.targetFramework);
        script.setTempFileName(this.tempFileName);
        script.setUseDebug(this.useDebug);
        script.setUseLogger(this.useLogger);
        script.setUseQuiet(this.useQuiet);
        long startTime = System.currentTimeMillis();
        ScriptRunner scriptRunner = new ScriptRunner();
        boolean scriptCompleted = scriptRunner.runScript(workingDir, script, this.timeout);
        long endTime = System.currentTimeMillis();
        File logFile = new File(this.nantWorkingDir, this.tempFileName);
        if (!scriptCompleted) {
            LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
            buildLogElement = new Element("build");
            buildLogElement.setAttribute("error", "build timeout");
        } else {
            buildLogElement = this.getNantLogAsElement(logFile);
            this.saveNantLog(logFile);
            logFile.delete();
        }
        Element element = this.translateNantErrorElements(buildLogElement);
        element.setAttribute("time", DateUtil.getDurationAsString(endTime - startTime));
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String buildTarget, Progress progress) throws CruiseControlException {
        String origTarget = this.target;
        try {
            this.target = buildTarget;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.target = origTarget;
        }
    }

    protected NantScript getNantScript() {
        return new NantScript();
    }

    public void setSaveLogDir(String dir) {
        this.saveLogDir = null;
        if (dir != null && !dir.trim().equals("")) {
            this.saveLogDir = new File(dir.trim());
        }
    }

    public void setNantWorkingDir(String dir) {
        this.nantWorkingDir = dir;
    }

    public void setTempFile(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNantLog(File logFile) {
        if (this.saveLogDir == null) {
            return;
        }
        try {
            File newNantLogFile = new File(this.saveLogDir, this.tempFileName);
            newNantLogFile.createNewFile();
            FileInputStream in = new FileInputStream(logFile);
            try {
                FileOutputStream out = new FileOutputStream(newNantLogFile);
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            LOG.error((Object)("Unable to create file: " + new File(this.saveLogDir, this.tempFileName)));
        }
    }

    public Property createProperty() {
        Property property = new Property();
        this.properties.add(property);
        return property;
    }

    protected Element getNantLogAsElement(File file) throws CruiseControlException {
        if (!file.exists()) {
            throw new CruiseControlException("NAnt logfile " + file.getAbsolutePath() + " does not exist.");
        }
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            EmptyElementFilter emptyTaskFilter = new EmptyElementFilter("task");
            EmptyElementFilter emptyMessageFilter = new EmptyElementFilter("message");
            emptyMessageFilter.setParent(emptyTaskFilter);
            builder.setXMLFilter((XMLFilter)emptyMessageFilter);
            return builder.build(file).getRootElement();
        }
        catch (Exception ee) {
            if (ee instanceof CruiseControlException) {
                throw (CruiseControlException)ee;
            }
            File saveFile = new File(file.getParentFile(), System.currentTimeMillis() + file.getName());
            file.renameTo(saveFile);
            throw new CruiseControlException("Error reading : " + file.getAbsolutePath() + ".  Saved as : " + saveFile.getAbsolutePath(), ee);
        }
    }

    public void setUseDebug(boolean debug) {
        this.useDebug = debug;
    }

    public void setUseQuiet(boolean quiet) {
        this.useQuiet = quiet;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String logger) {
        this.loggerClassName = logger;
    }

    public void setTargetFramework(String framework) {
        this.targetFramework = framework;
    }

    protected Element translateNantErrorElements(Element buildLogElement) throws CruiseControlException {
        buildLogElement.setName("build");
        Element failure = buildLogElement.getChild("failure");
        if (failure != null) {
            Element buildError = failure.getChild("builderror");
            if (buildError == null) {
                throw new CruiseControlException("Expected a builderror element under build/failure");
            }
            Element message = buildError.getChild("message");
            if (message == null) {
                throw new CruiseControlException("Expected a message element under build/failure/builderror");
            }
            List matches = message.getContent((Filter)new ContentFilter(2));
            if (matches.size() == 0) {
                throw new CruiseControlException("Expected CDATA content in build/failure/builderror/message/element");
            }
            String errorMessage = ((CDATA)matches.get(0)).getText();
            buildLogElement.setAttribute(new Attribute("error", errorMessage));
        }
        return buildLogElement;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

