/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Maven2Script;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven2Builder
extends Builder {
    private static final Logger LOG = Logger.getLogger(Maven2Builder.class);
    static final String MVN_BIN_DIR = "bin" + File.separator;
    private String mvnHome;
    private String mvnScript;
    private String pomFile;
    private String goal;
    private String sitegoal;
    private String settingsFile;
    private String activateProfiles;
    private long timeout = -1L;
    private String flags;
    private final List<Property> properties = new ArrayList<Property>();

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    String getSettingsFile() {
        return this.settingsFile;
    }

    public void setActivateProfiles(String activateProfiles) {
        this.activateProfiles = activateProfiles;
    }

    String getActivateProfiles() {
        return this.activateProfiles;
    }

    public void setMvnHome(String mvnHome) {
        if (!mvnHome.endsWith(File.separator)) {
            mvnHome = mvnHome + File.separator;
        }
        this.mvnHome = mvnHome;
        LOG.debug((Object)("MvnHome = " + this.mvnHome + " Mvn should be in " + this.mvnHome + MVN_BIN_DIR));
    }

    public void setMvnScript(String mvnScipt) {
        this.mvnScript = mvnScipt;
    }

    String getMvnScript() {
        return this.mvnScript;
    }

    public void setPomFile(String pomFile) {
        this.pomFile = pomFile;
        LOG.debug((Object)("pom file : " + this.pomFile));
    }

    String getPomFile() {
        return this.pomFile;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public void setSitegoal(String sitegoal) {
        this.sitegoal = sitegoal;
    }

    public Property createProperty() {
        Property property = new Property();
        this.properties.add(property);
        return property;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertFalse(this.mvnScript != null && this.mvnHome != null, "'mvnhome' and 'mvnscript' cannot both be set.\n\tmvnhome: " + this.mvnHome + ";\n\tmvnscript: " + this.mvnScript);
        if (this.mvnHome != null) {
            ValidationHelper.assertIsSet((Object)this.mvnHome, "mvnhome", this.getClass());
            File mvnHomeDir = new File(this.mvnHome);
            ValidationHelper.assertTrue(mvnHomeDir.exists() && mvnHomeDir.isDirectory(), "'mvnhome' must exist and be a directory. Expected to find " + mvnHomeDir.getAbsolutePath() + "; Check the mvnhome attribute of the maven2 plugin");
            this.mvnScript = this.findMaven2Script(Util.isWindows());
            LOG.debug((Object)("Using mvnHome: " + this.mvnHome + ", mvnScript found and set to: " + this.mvnScript));
        }
        ValidationHelper.assertTrue(this.mvnScript != null, "'mvnhome' or 'mvnscript' must be set.");
        ValidationHelper.assertIsSet((Object)this.pomFile, "pomfile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.goal, "goal", this.getClass());
        if (this.getGoalSets().isEmpty()) {
            ValidationHelper.assertIsSet(null, "goal", this.getClass());
        }
        if (this.settingsFile != null) {
            ValidationHelper.assertTrue(new File(this.settingsFile).exists(), "The settings file could not be found : " + this.settingsFile);
        }
    }

    @Override
    public Element build(Map<String, String> buildProperties, Progress progressIn) throws CruiseControlException {
        Progress progress = this.getShowProgress() ? progressIn : null;
        File filePomFile = new File(this.pomFile);
        this.validatePomFile(filePomFile);
        File workingDir = filePomFile.getAbsoluteFile().getParentFile();
        LOG.debug((Object)("Working dir is : " + workingDir.toString()));
        long startTime = System.currentTimeMillis();
        Element buildLogElement = new Element("build");
        List<String> goalSets = this.getGoalSets();
        this.build(buildProperties, workingDir, goalSets, buildLogElement, progress);
        List<String> sitegoalSets = this.getSitegoalSets();
        if (!sitegoalSets.isEmpty()) {
            this.build(buildProperties, workingDir, sitegoalSets, buildLogElement, progress);
        }
        long endTime = System.currentTimeMillis();
        buildLogElement.setAttribute("time", DateUtil.getDurationAsString(endTime - startTime));
        return buildLogElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(Map<String, String> buildProperties, File workingDir, List<String> goalSets, Element buildLogElement, Progress progress) throws CruiseControlException {
        Element element;
        Attribute saveErrorAttribute = buildLogElement.getAttribute("error");
        if (saveErrorAttribute != null) {
            element = buildLogElement;
            synchronized (element) {
                buildLogElement.removeAttribute(saveErrorAttribute);
            }
        }
        for (String goals : goalSets) {
            Element element2;
            Maven2Script script = new Maven2Script(this, buildLogElement, goals, progress);
            script.setBuildProperties(buildProperties);
            script.setProperties(this.properties);
            ScriptRunner scriptRunner = new ScriptRunner();
            boolean scriptCompleted = scriptRunner.runScript(workingDir, script, this.timeout);
            script.flushCurrentElement();
            if (!scriptCompleted) {
                LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
                element2 = buildLogElement;
                synchronized (element2) {
                    buildLogElement.setAttribute("error", "build timeout");
                }
            }
            if (script.getExitCode() != 0) {
                element2 = buildLogElement;
                synchronized (element2) {
                    buildLogElement.setAttribute("error", "Return code is " + script.getExitCode());
                }
            }
            if (buildLogElement.getAttribute("error") == null) continue;
            break;
        }
        if (saveErrorAttribute != null) {
            element = buildLogElement;
            synchronized (element) {
                buildLogElement.setAttribute(saveErrorAttribute);
            }
        }
    }

    void validatePomFile(File filePomFile) throws CruiseControlException {
        ValidationHelper.assertTrue(filePomFile.exists(), "the pom file could not be found : " + filePomFile.getAbsolutePath() + "; Check the 'pomfile' attribute: " + this.pomFile);
        ValidationHelper.assertTrue(filePomFile.isFile(), "the pom file can't be a directory : " + filePomFile.getAbsolutePath() + "; Check the 'pomfile' attribute: " + this.pomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String target, Progress progress) throws CruiseControlException {
        String origGoal = this.goal;
        try {
            this.goal = target;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.goal = origGoal;
        }
    }

    List<String> getGoalSets() {
        return this.getGoalSets(this.goal);
    }

    List<String> getSitegoalSets() {
        return this.getGoalSets(this.sitegoal);
    }

    private List<String> getGoalSets(String goalattribute) {
        ArrayList<String> list = new ArrayList<String>();
        if (goalattribute != null) {
            StringTokenizer stok = new StringTokenizer(goalattribute, "|");
            while (stok.hasMoreTokens()) {
                String subSet = stok.nextToken().trim();
                if (subSet == null || subSet.length() == 0) continue;
                list.add(subSet);
            }
        }
        return list;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    String getFlags() {
        return this.flags;
    }

    protected String findMaven2Script(boolean isWindows) throws CruiseControlException {
        if (this.mvnHome == null) {
            throw new CruiseControlException("mvnhome attribute not set.");
        }
        if (isWindows) {
            return this.mvnHome + MVN_BIN_DIR + "mvn.bat";
        }
        return this.mvnHome + MVN_BIN_DIR + "mvn";
    }
}

