/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBuilder
extends Builder {
    private static final Logger LOG = Logger.getLogger(CompositeBuilder.class);
    private final List<Builder> builders = new ArrayList<Builder>();
    private long startTime = 0L;
    private long timeoutSeconds = -1L;
    private boolean isTimedOut;
    private long childStartTime = 0L;

    public void add(Builder builder) {
        this.builders.add(builder);
    }

    private void startBuild() {
        this.startTime = System.currentTimeMillis();
    }

    private void endBuild(Element buildResult) {
        if (this.isTimedOut) {
            LOG.warn((Object)("Composite Build timeout timer of " + this.timeoutSeconds + " seconds has expired"));
            buildResult.setAttribute("error", "build timeout");
        }
        long endTime = System.currentTimeMillis();
        buildResult.setAttribute("time", DateUtil.getDurationAsString(endTime - this.startTime));
    }

    private void checkTimedOut() {
        if (this.timeoutSeconds != -1L && System.currentTimeMillis() - this.startTime > this.timeoutSeconds * 1000L) {
            this.isTimedOut = true;
        }
    }

    private void startChild() {
        this.childStartTime = System.currentTimeMillis();
    }

    private static boolean processBuildResult(Element buildResult, Element compositeBuildResult, String buildlogMsgPrefix, Builder builder, long childStartTime) {
        CompositeBuilder.insertBuildLogHeader(buildResult, buildlogMsgPrefix + " - " + builder.getClass().getName(), childStartTime);
        compositeBuildResult.addContent((Collection)buildResult.removeContent());
        if (!CompositeBuilder.isBuildSuccessful(buildResult)) {
            LOG.debug((Object)"CompositeBuilder: error element found, stopping)");
            Attribute attribute = buildResult.getAttribute("error");
            attribute.detach();
            compositeBuildResult.setAttribute(attribute);
            return true;
        }
        return false;
    }

    private static void insertBuildLogHeader(Element buildResult, String buildLogMsg, long childStartTime) {
        String buildMsgWithAttibs = buildLogMsg + "; child build attributes: ";
        for (Attribute attribute : buildResult.getAttributes()) {
            buildMsgWithAttibs = buildMsgWithAttibs + attribute.getName() + "=" + attribute.getValue() + "; ";
        }
        Element target = new Element("target");
        target.setAttribute("name", "composite");
        target.setAttribute("time", DateUtil.getDurationAsString(System.currentTimeMillis() - childStartTime));
        Element task = new Element("task");
        task.setAttribute("name", "composite-childbuilder");
        Element msg = new Element("message");
        msg.addContent((Content)new CDATA(buildMsgWithAttibs));
        msg.setAttribute("priority", "warn");
        task.addContent((Content)msg);
        target.addContent((Content)task);
        buildResult.addContent(0, (Content)target);
        Element msgBuild = new Element("message");
        msgBuild.addContent((Content)new CDATA(buildMsgWithAttibs));
        msgBuild.setAttribute("priority", "warn");
        buildResult.addContent(1, (Content)msgBuild);
    }

    private static boolean isBuildSuccessful(Element buildResult) {
        return buildResult.getAttribute("error") == null;
    }

    @Override
    public Element build(Map<String, String> properties, Progress progressIn) throws CruiseControlException {
        Progress progress = this.getShowProgress() ? progressIn : null;
        boolean errorOcurred = false;
        Element compositeBuildResult = new Element("build");
        Iterator<Builder> iter = this.builders.iterator();
        int i = 0;
        int totalBuilders = this.builders.size();
        this.startBuild();
        while (iter.hasNext() & !errorOcurred & !this.isTimedOut) {
            String buildlogMsgPrefix = "composite build " + ++i + " of " + totalBuilders;
            if (progress != null) {
                progress.setValue(buildlogMsgPrefix);
            }
            Builder builder = iter.next();
            this.startChild();
            Element buildResult = builder.build(properties, progress);
            errorOcurred = CompositeBuilder.processBuildResult(buildResult, compositeBuildResult, buildlogMsgPrefix, builder, this.childStartTime);
            this.checkTimedOut();
        }
        this.endBuild(compositeBuildResult);
        return compositeBuildResult;
    }

    @Override
    public Element buildWithTarget(Map<String, String> properties, String target, Progress progressIn) throws CruiseControlException {
        Progress progress = this.getShowProgress() ? progressIn : null;
        boolean errorOcurred = false;
        Element compositeBuildResult = new Element("build");
        Iterator<Builder> iter = this.builders.iterator();
        int i = 0;
        int totalBuilders = this.builders.size();
        this.startBuild();
        while (iter.hasNext() & !errorOcurred & !this.isTimedOut) {
            String buildlogMsgPrefix = "composite build " + ++i + " of " + totalBuilders;
            if (progress != null) {
                progress.setValue(buildlogMsgPrefix);
            }
            Builder builder = iter.next();
            this.startChild();
            Element buildResult = builder.buildWithTarget(properties, target, progress);
            errorOcurred = CompositeBuilder.processBuildResult(buildResult, compositeBuildResult, buildlogMsgPrefix, builder, this.childStartTime);
            this.checkTimedOut();
        }
        this.endBuild(compositeBuildResult);
        return compositeBuildResult;
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.builders.isEmpty(), "no builders added");
        super.validate();
        for (Builder builder : this.builders) {
            builder.validate();
        }
    }

    public Builder[] getBuilders() {
        return this.builders.toArray(new Builder[this.builders.size()]);
    }

    public void setTimeout(long timeout) {
        this.timeoutSeconds = timeout;
    }
}

