/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.EnvCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class VssBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(VssBootstrapper.class);
    private String ssDir;
    private String serverPath;
    private String vssPath;
    private String localDirectory;
    private String login;

    public void bootstrap() throws CruiseControlException {
        this.generateCommandLine().executeAndWait(LOG);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.vssPath != null && this.localDirectory != null, "VssBootstrapper has required attributes vssPath and localDirectory");
        File localDirForFile = new File(this.localDirectory);
        ValidationHelper.assertTrue(localDirForFile.exists(), "file path attribute value " + this.localDirectory + " must specify an existing directory.");
        ValidationHelper.assertTrue(localDirForFile.isDirectory(), "file path attribute value " + this.localDirectory + " must specify an existing directory, not a file.");
        this.setLocalDirectory(localDirForFile.getAbsolutePath());
    }

    private String getExecutable() {
        String executable = "";
        if (this.ssDir != null) {
            executable = this.ssDir;
            if (this.ssDir.charAt(this.ssDir.length() - 1) != '\\') {
                executable = executable + '\\';
            }
        }
        executable = executable + "ss.exe";
        return executable;
    }

    Commandline generateCommandLine() {
        EnvCommandline command = new EnvCommandline();
        command.setExecutable(this.getExecutable());
        command.createArgument("get");
        if (this.serverPath != null) {
            command.setVariable("SSDIR", this.serverPath);
        }
        if (this.vssPath != null) {
            String pathPrefix = this.vssPath.startsWith("$") ? "" : "$";
            command.createArgument('\"' + pathPrefix + this.vssPath + '\"');
        }
        command.createArgument("-GL\"" + this.localDirectory + '\"');
        command.createArgument("-I-N");
        if (this.login != null) {
            command.createArgument("-Y" + this.login);
        }
        return command;
    }

    public void setVssPath(String vssPath) {
        this.vssPath = vssPath;
    }

    public void setSsDir(String ssDir) {
        this.ssDir = ssDir;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setLogin(String login) {
        this.login = login;
    }
}

