/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class SVNBootstrapper
implements Bootstrapper {
    private static final long serialVersionUID = -4444449761990187324L;
    private static final Logger LOG = Logger.getLogger(SVNBootstrapper.class);
    private String fileName;
    private String localWorkingCopy;
    private String userName;
    private String password;
    private String configDir;

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setLocalWorkingCopy(String localWorkingCopy) {
        this.localWorkingCopy = localWorkingCopy;
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.fileName != null || this.localWorkingCopy != null, "At least 'filename' or 'localWorkingCopy' is a required attribute on the Subversion bootstrapper task");
        if (this.localWorkingCopy != null) {
            File workingDir = new File(this.localWorkingCopy);
            ValidationHelper.assertTrue(workingDir.exists() && workingDir.isDirectory(), "'localWorkingCopy' must be an existing directory. Was" + workingDir.getAbsolutePath());
        }
    }

    public void bootstrap() throws CruiseControlException {
        this.buildUpdateCommand().executeAndWait(LOG);
    }

    Commandline buildUpdateCommand() throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("svn");
        if (this.localWorkingCopy != null) {
            command.setWorkingDirectory(this.localWorkingCopy);
        }
        command.createArgument("update");
        command.createArgument("--non-interactive");
        if (this.configDir != null) {
            command.createArguments("--config-dir", this.configDir);
        }
        if (this.userName != null || this.password != null) {
            command.createArgument("--no-auth-cache");
            if (this.userName != null) {
                command.createArguments("--username", this.userName);
            }
            if (this.password != null) {
                command.createArguments("--password", this.password);
            }
        }
        if (this.fileName != null) {
            command.createArgument(this.fileName);
        }
        LOG.debug((Object)("SVNBootstrapper: Executing command = " + command));
        return command;
    }
}

