/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.sourcecontrols.SSCM;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSCMBootstrapper
implements Bootstrapper {
    private final SSCM.SSCMCLIStringParam strparamBranch = new SSCM.SSCMCLIStringParam("branch", "-b", false);
    private final SSCM.SSCMCLIStringParam strparamRepository = new SSCM.SSCMCLIStringParam("repository", "-p", false);
    private final SSCM.SSCMCLIStringParam strparamLabel = new SSCM.SSCMCLIStringParam("label", "-l", false);
    private final SSCM.SSCMCLIStringParam strparamServerConnect = new SSCM.SSCMCLIStringParam("serverconnect", "-z", false);
    private final SSCM.SSCMCLIStringParam strparamServerLogin = new SSCM.SSCMCLIStringParam("serverlogin", "-y", false);
    private final SSCM.SSCMCLIStringParam strparamIncludeRemovedFiles = new SSCM.SSCMCLIStringParam("includeremoved", "-i", false);
    private final SSCM.SSCMCLIStringParam strparamOverwrite = new SSCM.SSCMCLIStringParam("overwrite", "-w", false);
    private final SSCM.SSCMCLIBoolParam fparamRecursive = new SSCM.SSCMCLIBoolParam("recursive", "-r", false);
    private final SSCM.SSCMCLIBoolParam fparamForceFetch = new SSCM.SSCMCLIBoolParam("force", "-f", false);
    private final SSCM.SSCMCLIBoolParam fparamMakeWritable = new SSCM.SSCMCLIBoolParam("writable", "-e", false);
    private static final Logger LOG = Logger.getLogger(SSCMBootstrapper.class);

    @Override
    public void validate() throws CruiseControlException {
    }

    @Override
    public void bootstrap() throws CruiseControlException {
        ArrayList<SSCM.SSCMCLIParam> paramList = new ArrayList<SSCM.SSCMCLIParam>();
        SSCM.SSCMCLIStringParam strparamFile = new SSCM.SSCMCLIStringParam("file", "", false);
        strparamFile.setData("/");
        paramList.add(strparamFile);
        paramList.add(this.strparamBranch);
        paramList.add(this.strparamRepository);
        paramList.add(this.fparamMakeWritable);
        paramList.add(this.fparamForceFetch);
        paramList.add(this.strparamLabel);
        if (this.strparamLabel.isSet()) {
            paramList.add(this.strparamIncludeRemovedFiles);
        }
        paramList.add(this.fparamRecursive);
        if (!this.fparamForceFetch.isSet()) {
            if (!this.strparamOverwrite.isSet()) {
                this.strparamOverwrite.setData("skip");
            }
            paramList.add(this.strparamOverwrite);
        }
        paramList.add(this.strparamServerLogin);
        paramList.add(this.strparamServerConnect);
        this.executeCLICommand(paramList);
    }

    public void setBranch(String str) {
        this.strparamBranch.setData(str);
    }

    public void setRepository(String str) {
        this.strparamRepository.setData(str);
    }

    public void setLabel(String str) {
        this.strparamLabel.setData(str);
    }

    public void setServerConnect(String str) {
        this.strparamServerConnect.setData(str);
    }

    public void setServerLogin(String str) {
        this.strparamServerLogin.setData(str);
    }

    public void setIncludeRemovedFiles(boolean f) {
        this.strparamIncludeRemovedFiles.setData(f ? "" : "-");
    }

    public void setOverwrite(boolean f) {
        this.strparamOverwrite.setData(f ? "replace" : "skip");
    }

    public void setRecursive(boolean f) {
        if (f) {
            this.fparamRecursive.setData(null);
        }
    }

    public void setForceFetch(boolean f) {
        if (f) {
            this.fparamForceFetch.setData(null);
        }
    }

    public void setMakeWritable(boolean f) {
        if (f) {
            this.fparamMakeWritable.setData(null);
        }
    }

    protected void executeCLICommand(List<SSCM.SSCMCLIParam> paramList) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("sscm");
        command.createArgument().setValue("get");
        for (SSCM.SSCMCLIParam param : paramList) {
            if (param == null) {
                throw new IllegalArgumentException("paramList may not contain null values");
            }
            if (param.checkRequired()) {
                String str = param.getFormatted();
                if (str == null) continue;
                command.createArgument().setValue(str);
                LOG.debug((Object)("Added cmd part: " + str));
                continue;
            }
            throw new CruiseControlException("Required parameter '" + param.getParamName() + "' is missing!");
        }
        try {
            Process process = command.execute();
            new Thread(new StreamPumper(process.getInputStream(), StreamLogger.getInfoLogger(LOG))).start();
            Thread stderr = new Thread(new StreamPumper(process.getErrorStream(), StreamLogger.getInfoLogger(LOG)));
            stderr.start();
            process.waitFor();
            stderr.join();
            IO.close(process);
        }
        catch (IOException e) {
            throw new CruiseControlException("Problem trying to execute command line process", e);
        }
        catch (InterruptedException e) {
            throw new CruiseControlException("Problem trying to execute command line process", e);
        }
    }
}

