/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class PlasticSCMBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(PlasticSCMBootstrapper.class);
    private String branch;
    private String wkspath;
    private String repository;
    private String pathtoupdate;
    private boolean forced = false;

    public void setWkspath(String wkspath) {
        this.wkspath = wkspath;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setPathtoupdate(String pathtoupdate) {
        this.pathtoupdate = pathtoupdate;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void bootstrap() throws CruiseControlException {
        if (this.branch != null) {
            this.buildSwitchToBranchCommand().executeAndWait(LOG);
        }
        this.buildUpdateCommand().executeAndWait(LOG);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.wkspath, "wkspath", this.getClass());
        File workingDir = new File(this.wkspath);
        ValidationHelper.assertTrue(workingDir.exists(), "'wkspath' must be an existing directory. Was <" + this.wkspath + ">");
        ValidationHelper.assertTrue(workingDir.isDirectory(), "'wkspath' must be an existing directory, not a file. Was <" + this.wkspath + ">");
        if (this.repository != null) {
            ValidationHelper.assertIsDependentSet(this.repository, "repository", this.branch, "branch", this.getClass());
        }
    }

    protected Commandline buildUpdateCommand() throws CruiseControlException {
        Commandline commandLine = new Commandline();
        commandLine.setWorkingDirectory(this.wkspath);
        commandLine.setExecutable("cm");
        commandLine.createArgument("update");
        if (this.pathtoupdate != null) {
            commandLine.createArgument(this.pathtoupdate);
        } else {
            commandLine.createArgument(".");
        }
        if (this.forced) {
            commandLine.createArgument("--forced");
        }
        return commandLine;
    }

    protected Commandline buildSwitchToBranchCommand() throws CruiseControlException {
        Commandline commandLine = new Commandline();
        commandLine.setWorkingDirectory(this.wkspath);
        commandLine.setExecutable("cm");
        commandLine.createArgument("stb");
        commandLine.createArgument(this.branch);
        if (this.repository != null) {
            commandLine.createArgument("-repository=".concat(this.repository));
        }
        commandLine.createArgument("--noupdate");
        return commandLine;
    }
}

