/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class P4Bootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(P4Bootstrapper.class);
    private String view;
    private String port;
    private String client;
    private String user;
    private String passwd;

    public void setPort(String port) {
        this.port = port;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setView(String view) {
        this.view = view;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setPath(String path) {
        LOG.warn((Object)"The path attribute is deprecated, please use view attribute instead.");
        this.view = path;
    }

    public void setP4Port(String p4Port) {
        LOG.warn((Object)"The p4Port attribute is deprecated, please use port attribute instead.");
        this.port = p4Port;
    }

    public void setP4Client(String p4Client) {
        LOG.warn((Object)"The p4Client attribute is deprecated, please use client attribute instead.");
        this.client = p4Client;
    }

    public void setP4User(String p4User) {
        LOG.warn((Object)"The p4User attribute is deprecated, please use user attribute instead.");
        this.user = p4User;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.view, "view", this.getClass());
        ValidationHelper.assertNotEmpty(this.view, "view", this.getClass());
        ValidationHelper.assertNotEmpty(this.port, "P4Port", this.getClass());
        ValidationHelper.assertNotEmpty(this.client, "P4Client", this.getClass());
        ValidationHelper.assertNotEmpty(this.user, "P4User", this.getClass());
        ValidationHelper.assertNotEmpty(this.passwd, "P4Passwd", this.getClass());
    }

    public void bootstrap() throws CruiseControlException {
        Commandline commandline = this.createCommandline();
        LOG.debug((Object)("Executing commandline [" + commandline + "]"));
        this.executeCommandLine(commandline);
    }

    public Commandline createCommandline() throws CruiseControlException {
        this.validate();
        Commandline cmd = new Commandline();
        cmd.setExecutable("p4");
        cmd.createArgument("-s");
        if (this.port != null) {
            cmd.createArguments("-p", this.port);
        }
        if (this.client != null) {
            cmd.createArguments("-c", this.client);
        }
        if (this.user != null) {
            cmd.createArguments("-u", this.user);
        }
        if (this.passwd != null) {
            cmd.createArguments("-P", this.passwd);
        }
        cmd.createArguments("sync", this.view);
        return cmd;
    }

    private void executeCommandLine(Commandline commandline) throws CruiseControlException {
        commandline.executeAndWait(LOG);
    }
}

