/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.io.File;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class GitBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(GitBootstrapper.class);
    private String lwc;

    public void setLocalWorkingCopy(String d) {
        this.lwc = d;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.lwc != null, "'localWorkingCopy' is a required attribute on the Git bootstrapper task");
        File wd = new File(this.lwc);
        ValidationHelper.assertTrue(wd.exists() && wd.isDirectory(), "'localWorkingCopy' must be an existing directory. Was" + wd.getAbsolutePath());
    }

    public void bootstrap() throws CruiseControlException {
        Commandline cmd = new Commandline();
        cmd.setExecutable("git");
        cmd.setWorkingDirectory(this.lwc);
        cmd.createArgument("pull");
        cmd.executeAndWait(LOG);
    }
}

