/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import java.util.HashMap;
import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.builders.ExecBuilder;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class ExecBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(ExecBootstrapper.class);
    private final ExecBuilder delegate = new ExecBuilder();

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.delegate.getCommand(), "command", this.getClass());
        this.delegate.validate();
    }

    public void bootstrap() throws CruiseControlException {
        Element result = this.delegate.build(new HashMap<String, String>(), null);
        if (result == null) {
            LOG.error((Object)"ExecBootstrapper failed.\n\n");
            throw new CruiseControlException("ExecBootstrapper failed with null result");
        }
        Attribute error = result.getAttribute("error");
        if (error != null) {
            LOG.error((Object)("ExecBootstrapper failed.\n\n" + error.getValue() + "\n"));
            throw new CruiseControlException("ExecBootstrapper failed: " + error.getValue());
        }
        LOG.info((Object)"ExecBootstrapper successful.");
    }

    public void setTimeout(long timeout) {
        this.delegate.setTimeout(timeout);
    }

    public void setCommand(String cmd) {
        this.delegate.setCommand(cmd);
    }

    public void setArgs(String args) {
        this.delegate.setArgs(args);
    }

    public void setErrorStr(String errStr) {
        this.delegate.setErrorStr(errStr);
    }

    public void setWorkingDir(String dir) {
        this.delegate.setWorkingDir(dir);
    }
}

