/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.bootstrappers;

import net.sourceforge.cruisecontrol.Bootstrapper;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class ClearCaseBootstrapper
implements Bootstrapper {
    private static final Logger LOG = Logger.getLogger(ClearCaseBootstrapper.class);
    private String filename;
    private String viewpath;

    public void setViewpath(String path) {
        this.viewpath = path;
    }

    public void setFile(String name) {
        this.filename = name;
    }

    public void bootstrap() throws CruiseControlException {
        this.buildUpdateCommand().executeAndWait(LOG);
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.filename, "file", this.getClass());
    }

    protected Commandline buildUpdateCommand() {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArgument("update");
        commandLine.createArgument("-force");
        commandLine.createArguments("-log", this.isWindows() ? "NUL" : "/dev/null");
        commandLine.createArgument(this.getFullPathFileName());
        return commandLine;
    }

    private String getFullPathFileName() {
        return this.viewpath == null ? this.filename : new StringBuffer(this.viewpath).append("/").append(this.filename).toString();
    }

    protected boolean isWindows() {
        return this.getOsName().indexOf("Windows") >= 0;
    }

    protected String getOsName() {
        return System.getProperty("os.name");
    }
}

