/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.PauseBuilder;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schedule
implements Serializable {
    private static final long serialVersionUID = -33682332427948426L;
    private static final Logger LOG = Logger.getLogger(Schedule.class);
    static final long ONE_SECOND = 1000L;
    static final long ONE_MINUTE = 60000L;
    static final long ONE_DAY = 86400000L;
    static final long ONE_YEAR = 31536000000L;
    static final long MAX_INTERVAL_SECONDS = 31536000L;
    static final long MAX_INTERVAL_MILLISECONDS = 31536000000L;
    private final List<Builder> builders = new ArrayList<Builder>();
    private final List<PauseBuilder> pauseBuilders = new ArrayList<PauseBuilder>();
    private long interval = 300000L;
    private boolean showProgress = true;
    private final DateFormat timeFormatter = new SimpleDateFormat("HH:mm");
    private final Comparator<Builder> builderComparator = new BuilderComparitor();

    public void add(Builder builder) {
        this.checkParamNotNull("builder", builder);
        this.builders.add(builder);
        Collections.sort(this.builders, this.builderComparator);
    }

    public void add(PauseBuilder pause) {
        this.checkParamNotNull("pauseBuilder", pause);
        this.pauseBuilders.add(pause);
    }

    public boolean isPaused(Date now) {
        this.checkParamNotNull("date", now);
        PauseBuilder pause = this.findPause(now);
        if (pause != null) {
            LOG.info((Object)("CruiseControl is paused until: " + this.getEndTimeString(pause)));
            return true;
        }
        return false;
    }

    private String getEndTimeString(PauseBuilder builder) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, builder.getEndTime() / 100);
        cal.set(12, builder.getEndTime() % 100);
        cal.add(12, 1);
        return this.timeFormatter.format(cal.getTime());
    }

    PauseBuilder findPause(Date date) {
        this.checkParamNotNull("date", date);
        for (PauseBuilder pause : this.pauseBuilders) {
            if (!pause.isPaused(date)) continue;
            return pause;
        }
        return null;
    }

    public Element build(int buildNumber, Date lastBuild, Date now, Map<String, String> properties, String buildTarget, Progress progress) throws CruiseControlException {
        Builder builder = this.selectBuilder(buildNumber, lastBuild, now);
        if (buildTarget != null) {
            LOG.info((Object)("Overriding build target with \"" + buildTarget + "\""));
            return builder.buildWithTarget(properties, buildTarget, this.getShowProgress() ? progress : null);
        }
        return builder.build(properties, this.getShowProgress() ? progress : null);
    }

    protected Builder selectBuilder(int buildNumber, Date lastBuild, Date now) throws CruiseControlException {
        Builder builder = this.findBuilder(buildNumber, lastBuild, now);
        if (builder == null) {
            long timeToNextBuild = this.getTimeToNextBuild(now, 60000L);
            Date futureDate = this.getFutureDate(now, timeToNextBuild);
            builder = this.findBuilder(buildNumber, now, futureDate);
        }
        if (builder == null) {
            this.validate();
            throw new CruiseControlException("configuration error not caught by validate? no builder selected");
        }
        return builder;
    }

    private Builder findBuilder(int buildNumber, Date lastBuild, Date now) throws CruiseControlException {
        for (Builder builder : this.builders) {
            if (builder.isTimeBuilder()) {
                int buildTime = builder.getTime();
                boolean didntBuildToday = this.builderDidntBuildToday(lastBuild, now, buildTime);
                int nowTime = DateUtil.getTimeFromDate(now);
                boolean isAfterBuildTime = buildTime <= nowTime;
                boolean isValidDay = builder.isValidDay(now);
                if (!didntBuildToday || !isAfterBuildTime || !isValidDay) continue;
                return builder;
            }
            if (builder.getMultiple() > 0) {
                if (!builder.isValidDay(now) || buildNumber % builder.getMultiple() != 0) continue;
                return builder;
            }
            throw new CruiseControlException("The selected Builder is not properly configured");
        }
        return null;
    }

    boolean builderDidntBuildToday(Date lastBuild, Date now, int buildTime) {
        int time = DateUtil.getTimeFromDate(now);
        long timeMillis = DateUtil.convertToMillis(time);
        long startOfToday = now.getTime() - timeMillis;
        boolean lastBuildYesterday = lastBuild.getTime() < startOfToday;
        boolean lastBuildTimeBeforeBuildTime = DateUtil.getTimeFromDate(lastBuild) < buildTime;
        return lastBuildYesterday || lastBuildTimeBeforeBuildTime;
    }

    long getTimeToNextBuild(Date now, long sleepInterval) {
        return this.getTimeToNextBuild(now, sleepInterval, 0L);
    }

    private long getTimeToNextBuild(Date now, long sleepInterval, long priorPauseAdjustment) {
        long timeToNextBuild = sleepInterval;
        LOG.debug((Object)("getTimeToNextBuild: initial timeToNextBuild = " + timeToNextBuild));
        timeToNextBuild = this.checkMultipleBuilders(now, timeToNextBuild);
        LOG.debug((Object)("getTimeToNextBuild: after checkMultipleBuilders = " + timeToNextBuild));
        timeToNextBuild = this.checkTimeBuilders(now, timeToNextBuild);
        LOG.debug((Object)("getTimeToNextBuild: after checkTimeBuilders = " + timeToNextBuild));
        long timeTillNotPaused = this.checkPauseBuilders(now, timeToNextBuild);
        LOG.debug((Object)("getTimeToNextBuild: after checkPauseBuilders = " + timeToNextBuild));
        if (timeToNextBuild != timeTillNotPaused) {
            boolean atMaxTime;
            boolean bl = atMaxTime = timeTillNotPaused >= 31536000000L || priorPauseAdjustment >= 31536000000L;
            if (this.hasOnlyTimeBuilders() && !atMaxTime) {
                Date dateAfterPause = this.getFutureDate(now, timeTillNotPaused);
                long adjustmentFromEndOfPause = this.getTimeToNextBuild(dateAfterPause, 0L, priorPauseAdjustment + timeTillNotPaused);
                timeToNextBuild = timeTillNotPaused + adjustmentFromEndOfPause;
                timeToNextBuild = this.checkMaximumInterval(timeToNextBuild);
            } else {
                timeToNextBuild = timeTillNotPaused;
            }
        }
        return timeToNextBuild;
    }

    private long checkMultipleBuilders(Date now, long interval) {
        if (this.hasOnlyTimeBuilders()) {
            LOG.debug((Object)"has only time builders, so no correction for multiple builders.");
            return interval;
        }
        Date then = this.getFutureDate(now, interval);
        ArrayList<Builder> buildersForOtherDays = new ArrayList<Builder>();
        for (Builder builder : this.builders) {
            if (builder.isTimeBuilder() || builder.getMultiple() != 1) continue;
            if (builder.isValidDay(then)) {
                LOG.debug((Object)("multiple=1 builder found that could run on " + then));
                return interval;
            }
            buildersForOtherDays.add(builder);
        }
        if (buildersForOtherDays.size() == 0) {
            LOG.error((Object)"configuration error: has some multiple builders but no multiple=1 builders found!");
            return interval;
        }
        LOG.debug((Object)("no multiple=1 builders found for " + then + ". checking other days"));
        for (int i = 1; i < 7; ++i) {
            long daysPastInitialInterval = (long)i * 86400000L;
            then = this.getFutureDate(now, interval + daysPastInitialInterval);
            for (Builder builder : this.builders) {
                if (!builder.isValidDay(then)) continue;
                LOG.debug((Object)("multiple=1 builder found that could run on " + then));
                long correctionToMidnight = this.getTimePastMidnight(then);
                return interval + daysPastInitialInterval - correctionToMidnight;
            }
        }
        LOG.error((Object)"configuration error? could not find appropriate multiple=1 builder.");
        return interval;
    }

    private long getTimePastMidnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        long time = 3600000L * (long)cal.get(11);
        return time += 60000L * (long)cal.get(12);
    }

    private boolean hasOnlyTimeBuilders() {
        boolean onlyTimeBuilders = true;
        for (Builder builder : this.builders) {
            if (builder.isTimeBuilder()) continue;
            onlyTimeBuilders = false;
            break;
        }
        return onlyTimeBuilders;
    }

    long checkTimeBuilders(Date now, long proposedTime) {
        long timeToNextBuild = proposedTime;
        if (this.hasOnlyTimeBuilders()) {
            timeToNextBuild = Long.MAX_VALUE;
        }
        int nowTime = DateUtil.getTimeFromDate(now);
        for (Builder builder : this.builders) {
            if (!builder.isTimeBuilder()) continue;
            long timeToThisBuild = Long.MAX_VALUE;
            Calendar cal = Calendar.getInstance();
            long oneYear = 365L;
            int daysInTheFuture = 0;
            while ((long)daysInTheFuture < 365L) {
                cal.setTime(now);
                cal.add(5, daysInTheFuture);
                Date future = cal.getTime();
                boolean dayIsValid = builder.isValidDay(future);
                if (dayIsValid) {
                    boolean timePassedToday;
                    int thisBuildTime = builder.getTime();
                    boolean bl = timePassedToday = daysInTheFuture == 0 && nowTime > thisBuildTime;
                    if (!timePassedToday) {
                        int buildHour = thisBuildTime / 100;
                        int buildMinute = thisBuildTime % 100;
                        cal.set(11, buildHour);
                        cal.set(12, buildMinute);
                        future = cal.getTime();
                        timeToThisBuild = future.getTime() - now.getTime();
                        break;
                    }
                }
                ++daysInTheFuture;
            }
            if (timeToThisBuild >= timeToNextBuild) continue;
            timeToNextBuild = timeToThisBuild;
        }
        if (timeToNextBuild > 31536000000L) {
            LOG.error((Object)("checkTimeBuilders exceeding maximum interval. using proposed value [" + proposedTime + "] instead"));
            timeToNextBuild = proposedTime;
        }
        return timeToNextBuild;
    }

    long checkPauseBuilders(Date now, long proposedTime) {
        long oldTime = proposedTime;
        long newTime = this.checkForPauseAtProposedTime(now, oldTime);
        while (oldTime != newTime) {
            oldTime = newTime;
            newTime = this.checkForPauseAtProposedTime(now, oldTime);
        }
        return newTime;
    }

    private long checkForPauseAtProposedTime(Date now, long proposedTime) {
        Date futureDate = this.getFutureDate(now, proposedTime);
        PauseBuilder pause = this.findPause(futureDate);
        if (pause == null) {
            return proposedTime;
        }
        int endPause = pause.getEndTime();
        int futureTime = DateUtil.getTimeFromDate(futureDate);
        long timeToEndOfPause = proposedTime + DateUtil.milliTimeDifference(futureTime, endPause);
        return (timeToEndOfPause = this.checkMaximumInterval(timeToEndOfPause)) == 31536000000L ? timeToEndOfPause : timeToEndOfPause + 60000L;
    }

    private long checkMaximumInterval(long timeToEndOfPause) {
        if (timeToEndOfPause > 31536000000L) {
            LOG.error((Object)"maximum interval exceeded! project perpetually paused?");
            return 31536000000L;
        }
        return timeToEndOfPause;
    }

    private Date getFutureDate(Date now, long delay) {
        long futureMillis = now.getTime() + delay;
        return new Date(futureMillis);
    }

    public void setInterval(long intervalBetweenModificationChecks) {
        if (intervalBetweenModificationChecks <= 0L) {
            throw new IllegalArgumentException("interval must be greater than zero");
        }
        this.interval = intervalBetweenModificationChecks * 1000L;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.builders.size() > 0, "schedule element requires at least one nested builder element");
        ValidationHelper.assertFalse(this.interval > 31536000000L, "maximum interval value is 31536000 (one year)");
        if (this.hasOnlyTimeBuilders()) {
            LOG.warn((Object)"schedule has all time based builders: interval value will be ignored.");
            ValidationHelper.assertFalse(this.checkWithinPause(new ArrayList<Builder>(this.builders)), "all build times during pauses.");
        }
        for (Builder next : this.builders) {
            next.validate();
        }
    }

    private boolean checkWithinPause(List timeBuilders) {
        for (int i = 0; i < timeBuilders.size(); ++i) {
            Builder builder = (Builder)timeBuilders.get(i);
            for (PauseBuilder pauseBuilder : this.pauseBuilders) {
                if (!this.buildDaySameAsPauseDay(builder, pauseBuilder) || !this.buildTimeWithinPauseTime(builder, pauseBuilder)) continue;
                timeBuilders.remove(builder);
                StringBuffer message = new StringBuffer();
                message.append("time Builder for time ");
                message.append(Integer.toString(builder.getTime()));
                if (builder.getDay() != -1) {
                    message.append(" and day of ");
                    message.append(this.getDayString(builder.getDay()));
                }
                message.append(" is always within a pause and will never build");
                LOG.error((Object)message.toString());
            }
        }
        return timeBuilders.isEmpty();
    }

    String getDayString(int day) {
        if (day < 1 || day > 7) {
            throw new IllegalArgumentException("valid values of days are between 1 and 7, was " + day);
        }
        DateFormatSymbols symbols = new DateFormatSymbols(Locale.ENGLISH);
        String[] weekdays = symbols.getWeekdays();
        return weekdays[day];
    }

    private boolean buildDaySameAsPauseDay(Builder builder, PauseBuilder pauseBuilder) {
        return pauseBuilder.getDay() == -1 || pauseBuilder.getDay() == builder.getDay();
    }

    private boolean buildTimeWithinPauseTime(Builder builder, PauseBuilder pauseBuilder) {
        return pauseBuilder.getStartTime() < builder.getTime() && builder.getTime() < pauseBuilder.getEndTime();
    }

    private void checkParamNotNull(String paramName, Object param) {
        if (param == null) {
            throw new IllegalArgumentException(paramName + " can't be null");
        }
    }

    public List getBuilders() {
        return this.builders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuilderComparitor
    implements Comparator<Builder> {
        private BuilderComparitor() {
        }

        @Override
        public int compare(Builder b1, Builder b2) {
            if (b1.isTimeBuilder() && !b2.isTimeBuilder()) {
                return -1;
            }
            if (!b1.isTimeBuilder() && b2.isTimeBuilder()) {
                return 1;
            }
            if (b1.isTimeBuilder() && b2.isTimeBuilder()) {
                return this.checkDays(b1, b2);
            }
            if (b1.getMultiple() > b2.getMultiple()) {
                return -1;
            }
            if (b1.getMultiple() < b2.getMultiple()) {
                return 1;
            }
            return this.checkDays(b1, b2);
        }

        private int checkDays(Builder b1, Builder b2) {
            boolean b2HasDaySet;
            boolean b1HasDaySet = b1.getDay() >= 0;
            boolean bl = b2HasDaySet = b2.getDay() >= 0;
            if (b1HasDaySet && !b2HasDaySet) {
                return -1;
            }
            if (!b1HasDaySet && b2HasDaySet) {
                return 1;
            }
            return 0;
        }
    }
}

