/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ProjectState
implements Serializable {
    private static final Map<String, ProjectState> ALL_STATES = new HashMap<String, ProjectState>();
    public static final ProjectState QUEUED = new ProjectState(1, "queued", "in build queue");
    public static final ProjectState IDLE = new ProjectState(0, "idle", "idle");
    public static final ProjectState BOOTSTRAPPING = new ProjectState(2, "bootstrapping", "bootstrapping");
    public static final ProjectState MODIFICATIONSET = new ProjectState(3, "modificationset", "checking for modifications");
    public static final ProjectState BUILDING = new ProjectState(4, "building", "now building");
    public static final ProjectState MERGING_LOGS = new ProjectState(5, "merging", "merging accumulated log files");
    public static final ProjectState PUBLISHING = new ProjectState(6, "publishing", "publishing build results");
    public static final ProjectState PAUSED = new ProjectState(7, "paused", "paused");
    public static final ProjectState STOPPED = new ProjectState(8, "stopped", "stopped");
    public static final ProjectState WAITING = new ProjectState(9, "waiting", "waiting for next time to build");
    private final String description;
    private final String name;
    private final int code;

    private ProjectState(int code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.description = desc;
        ALL_STATES.put(name, this);
    }

    public String getDescription() {
        return this.description;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private Object readResolve() throws ObjectStreamException {
        return ALL_STATES.get(this.name);
    }

    public boolean hasDescription(String description) {
        return this.description.equals(description);
    }
}

