/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.Serializable;
import java.util.Date;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.Project;
import net.sourceforge.cruisecontrol.listeners.ProgressChangedEvent;
import net.sourceforge.cruisecontrol.util.DateUtil;

public class ProgressImpl
implements Progress {
    private static final long serialVersionUID = -660370539956160650L;
    private final Project project;
    private Serializable val;
    private Date lastUpdated;

    ProgressImpl(Project project) {
        this.project = project;
        this.setLastUpdated();
    }

    private void setLastUpdated() {
        this.lastUpdated = new Date();
    }

    public void setValue(String value) {
        this.val = value;
        this.setLastUpdated();
        this.project.notifyListeners(new ProgressChangedEvent(this.project.getName(), this));
    }

    public String getValue() {
        return DateUtil.getFormattedTime(this.lastUpdated) + " " + this.val;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getText() {
        return this.val != null ? this.val.toString() : null;
    }
}

