/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.cruisecontrol.ControllerAware;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.ProjectHelper;
import net.sourceforge.cruisecontrol.SelfConfiguringPlugin;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginXMLHelper {
    private static final Logger LOG = Logger.getLogger(PluginXMLHelper.class);
    private final ProjectHelper projectHelper;
    private final CruiseControlController controller;

    public PluginXMLHelper(ProjectHelper plugins) {
        this(plugins, null);
    }

    public PluginXMLHelper(ProjectHelper plugins, CruiseControlController controller) {
        this.projectHelper = plugins;
        this.controller = controller;
    }

    public Object configure(Element objectElement, Class pluginClass, boolean skipChildElements) throws CruiseControlException {
        Object pluginInstance = this.instantiatePlugin(pluginClass);
        return this.configure(objectElement, pluginInstance, skipChildElements);
    }

    private Object instantiatePlugin(Class pluginClass) throws CruiseControlException {
        Object pluginInstance;
        try {
            pluginInstance = pluginClass.getConstructor(null).newInstance(null);
            if (pluginInstance instanceof ControllerAware) {
                ((ControllerAware)pluginInstance).setController(this.controller);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not instantiate class", (Throwable)e);
            throw new CruiseControlException("Could not instantiate class: " + pluginClass.getName(), e);
        }
        return pluginInstance;
    }

    public Object configure(Element objectElement, Object pluginInstance, boolean skipChildElements) throws CruiseControlException {
        LOG.debug((Object)("configure " + objectElement.getName() + " instance " + pluginInstance.getClass() + " self configuring: " + (pluginInstance instanceof SelfConfiguringPlugin) + " skip:" + skipChildElements));
        if (pluginInstance instanceof SelfConfiguringPlugin) {
            ((SelfConfiguringPlugin)pluginInstance).configure(objectElement);
        } else {
            this.configureObject(objectElement, pluginInstance, skipChildElements);
        }
        return pluginInstance;
    }

    protected void configureObject(Element objectElement, Object object, boolean skipChildElements) throws CruiseControlException {
        Method[] methods;
        LOG.debug((Object)("configuring object " + objectElement.getName() + " object " + object.getClass() + " skip " + skipChildElements));
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap<String, Method> creators = new HashMap<String, Method>();
        HashSet<Method> adders = new HashSet<Method>();
        for (Method method : methods = object.getClass().getMethods()) {
            String name = method.getName();
            if (name.startsWith("set")) {
                setters.put(name.substring("set".length()).toLowerCase(Locale.US), method);
                continue;
            }
            if (name.startsWith("create")) {
                creators.put(name.substring("create".length()).toLowerCase(Locale.US), method);
                continue;
            }
            if (!name.equals("add") || method.getParameterTypes().length != 1) continue;
            adders.add(method);
        }
        this.setFromAttributes(objectElement, setters, object);
        if (!skipChildElements) {
            for (Element childElement : objectElement.getChildren()) {
                if (creators.containsKey(childElement.getName().toLowerCase(Locale.US))) {
                    LOG.debug((Object)("treating child with creator " + childElement.getName()));
                    try {
                        Method method = (Method)creators.get(childElement.getName().toLowerCase(Locale.US));
                        Object childObject = method.invoke(object, (Object[])null);
                        this.configureObject(childElement, childObject, false);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CruiseControlException(e.getMessage());
                    }
                }
                Object childObject = this.projectHelper.configurePlugin(childElement, false);
                Method adder = null;
                for (Method method : adders) {
                    Class<?> type = method.getParameterTypes()[0];
                    if (!type.isAssignableFrom(childObject.getClass())) continue;
                    adder = method;
                    break;
                }
                if (adder != null) {
                    try {
                        LOG.debug((Object)("treating child with adder " + childElement.getName() + " adding " + childObject));
                        adder.invoke(object, childObject);
                    }
                    catch (Exception e) {
                        LOG.fatal((Object)"Error configuring plugin.", (Throwable)e);
                    }
                    continue;
                }
                throw new CruiseControlException("Nested element: '" + childElement.getName() + "' is not supported for the <" + objectElement.getName() + "> tag.");
            }
        }
    }

    private void setFromAttributes(Element objectElement, Map<String, Method> setters, Object object) throws CruiseControlException {
        for (Attribute attribute : objectElement.getAttributes()) {
            this.callSetter(attribute.getName(), attribute.getValue(), setters, object);
        }
    }

    private void callSetter(String propName, String propValue, Map<String, Method> setters, Object object) throws CruiseControlException {
        block8: {
            if (setters.containsKey(propName.toLowerCase(Locale.US))) {
                LOG.debug((Object)("Setting " + propName.toLowerCase(Locale.US) + " to " + propValue));
                try {
                    Method method = setters.get(propName.toLowerCase(Locale.US));
                    Class<?>[] parameters = method.getParameterTypes();
                    if (String.class.isAssignableFrom(parameters[0])) {
                        method.invoke(object, propValue);
                        break block8;
                    }
                    if (Integer.TYPE.isAssignableFrom(parameters[0])) {
                        method.invoke(object, Integer.valueOf(propValue));
                        break block8;
                    }
                    if (Long.TYPE.isAssignableFrom(parameters[0])) {
                        method.invoke(object, Long.valueOf(propValue));
                        break block8;
                    }
                    if (Boolean.TYPE.isAssignableFrom(parameters[0])) {
                        method.invoke(object, Boolean.valueOf(propValue));
                        break block8;
                    }
                    LOG.error((Object)("rCouldn't invoke setter " + propName.toLowerCase(Locale.US)));
                }
                catch (Exception e) {
                    LOG.fatal((Object)"Error configuring plugin.", (Throwable)e);
                }
            } else {
                throw new CruiseControlException("Attribute: '" + propName + "' is not supported for class: '" + object.getClass().getName() + "'.");
            }
        }
    }
}

