/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationSet
implements Serializable {
    private static final long serialVersionUID = 7834545928469764690L;
    private boolean lieOnIsModified = false;
    private static final Logger LOG = Logger.getLogger(ModificationSet.class);
    private static final int ONE_SECOND = 1000;
    private List<Modification> modifications = new ArrayList<Modification>();
    private final List<SourceControl> sourceControls = new ArrayList<SourceControl>();
    private int quietPeriod = 60000;
    private Date timeOfCheck;
    private List<GlobFilenameFilter> ignoreFiles;
    static final String MSG_PROGRESS_PREFIX_QUIETPERIOD_MODIFICATION_SLEEP = "quiet period modification, sleep ";

    public void setQuietPeriod(int seconds) {
        this.quietPeriod = seconds * 1000;
    }

    public void setIgnoreFiles(String filePatterns) throws CruiseControlException {
        if (filePatterns != null) {
            StringTokenizer st = new StringTokenizer(filePatterns, ",");
            this.ignoreFiles = new ArrayList<GlobFilenameFilter>();
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                try {
                    this.ignoreFiles.add(new GlobFilenameFilter(pattern));
                }
                catch (MalformedCachePatternException e) {
                    throw new CruiseControlException("Invalid filename pattern '" + pattern + "'", e);
                }
            }
        }
    }

    public void add(SourceControl sourceControl) {
        this.sourceControls.add(sourceControl);
    }

    public List<SourceControl> getSourceControls() {
        return this.sourceControls;
    }

    protected boolean isLastModificationInQuietPeriod(Date timeOfCheck, List<Modification> modificationList) {
        boolean modificationInFuture;
        long lastModificationTime = this.getLastModificationMillis(modificationList);
        long quietPeriodStart = timeOfCheck.getTime() - (long)this.quietPeriod;
        boolean bl = modificationInFuture = new Date().getTime() < lastModificationTime;
        if (modificationInFuture) {
            LOG.warn((Object)"A modification has been detected in the future.  Building anyway.");
        }
        return quietPeriodStart <= lastModificationTime && !modificationInFuture;
    }

    protected long getLastModificationMillis(List<Modification> modificationList) {
        Date timeOfLastModification = new Date(0L);
        for (Modification modification : modificationList) {
            Date modificationDate = modification.modifiedTime;
            if (!modificationDate.after(timeOfLastModification)) continue;
            timeOfLastModification = modificationDate;
        }
        if (modificationList.size() > 0) {
            LOG.debug((Object)("Last modification: " + DateUtil.formatIso8601(timeOfLastModification)));
        } else {
            LOG.debug((Object)"list has no modifications; returning new Date(0).getTime()");
        }
        return timeOfLastModification.getTime();
    }

    protected long getQuietPeriodDifference(Date now, List<Modification> modificationList) {
        long diff = (long)this.quietPeriod - (now.getTime() - this.getLastModificationMillis(modificationList));
        return Math.max(0L, diff);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> table = new HashMap<String, String>();
        for (SourceControl control : this.sourceControls) {
            this.mergeProperties(table, control);
        }
        return table;
    }

    private void mergeProperties(Map<String, String> properties, SourceControl control) {
        Set<String> newKeys;
        Map<String, String> newProperties = control.getProperties();
        Set<String> existingKeys = properties.keySet();
        if (Collections.disjoint(existingKeys, newKeys = newProperties.keySet())) {
            properties.putAll(newProperties);
            return;
        }
        HashSet<String> disjointKeys = new HashSet<String>(newKeys);
        HashSet<String> unionKeys = new HashSet<String>(newKeys);
        disjointKeys.removeAll(existingKeys);
        unionKeys.retainAll(existingKeys);
        for (String key : disjointKeys) {
            properties.put(key, newProperties.get(key));
        }
        for (String key : unionKeys) {
            String oldValue = properties.get(key);
            String newValue = newProperties.get(key);
            String value = this.chooseValue(oldValue, newValue);
            properties.put(key, value);
        }
    }

    private String chooseValue(String oldValue, String newValue) {
        boolean oldBigger;
        if (oldValue.equals(newValue)) {
            return newValue;
        }
        if (newValue == null) {
            return newValue;
        }
        Integer oldInt = this.getInteger(oldValue);
        Integer newInt = this.getInteger(newValue);
        Date oldDate = this.getDate(oldValue);
        Date newDate = this.getDate(newValue);
        if (oldInt != null && newInt != null) {
            oldBigger = oldInt.compareTo(newInt) > 0;
        } else if (oldDate != null && newDate != null) {
            oldBigger = oldDate.compareTo(newDate) > 0;
        } else {
            boolean bl = oldBigger = oldValue.compareTo(newValue) > 0;
        }
        if (oldBigger) {
            return oldValue;
        }
        return newValue;
    }

    private Date getDate(String string) {
        try {
            return DateFormat.getDateInstance().parse(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Integer getInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List getCurrentModifications() {
        return this.modifications;
    }

    public Element getModifications(Date lastBuild) {
        return this.retrieveModificationsAsElement(lastBuild, null);
    }

    public Element retrieveModificationsAsElement(Date lastBuild, Progress progress) {
        Element modificationsElement;
        do {
            this.timeOfCheck = new Date();
            this.modifications = new ArrayList<Modification>();
            for (SourceControl sourceControl : this.sourceControls) {
                this.modifications.addAll(sourceControl.getModifications(lastBuild, this.timeOfCheck));
            }
            this.filterIgnoredModifications(this.modifications);
            if (this.modifications.size() > 0) {
                LOG.info((Object)(this.modifications.size() + (this.modifications.size() > 1 ? " modifications have been detected." : " modification has been detected.")));
            }
            modificationsElement = new Element("modifications");
            for (Modification modification : this.modifications) {
                Element modificationElement = modification.toElement();
                modification.log();
                modificationsElement.addContent((Content)modificationElement);
            }
            if (!this.isLastModificationInQuietPeriod(this.timeOfCheck, this.modifications)) continue;
            LOG.info((Object)"A modification has been detected in the quiet period.  ");
            if (LOG.isDebugEnabled()) {
                Date quietPeriodStart = new Date(this.timeOfCheck.getTime() - (long)this.quietPeriod);
                LOG.debug((Object)(DateUtil.formatIso8601(quietPeriodStart) + " <= Quiet Period <= " + DateUtil.formatIso8601(this.timeOfCheck)));
            }
            Date now = new Date();
            long timeToSleep = this.getQuietPeriodDifference(now, this.modifications);
            LOG.info((Object)("Sleeping for " + timeToSleep / 1000L + " seconds before retrying."));
            if (progress != null) {
                progress.setValue(MSG_PROGRESS_PREFIX_QUIETPERIOD_MODIFICATION_SLEEP + timeToSleep / 1000L + " secs");
            }
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e);
            }
        } while (this.isLastModificationInQuietPeriod(this.timeOfCheck, this.modifications));
        return modificationsElement;
    }

    protected void filterIgnoredModifications(List<Modification> modifications) {
        if (this.ignoreFiles != null) {
            Iterator<Modification> iterator = modifications.iterator();
            while (iterator.hasNext()) {
                Modification modification = iterator.next();
                if (!this.isIgnoredModification(modification)) continue;
                iterator.remove();
            }
        }
    }

    private boolean isIgnoredModification(Modification modification) {
        boolean foundAny = false;
        for (Modification.ModifiedFile modFile : modification.getModifiedFiles()) {
            File file;
            if (modFile.folderName == null) {
                if (modification.getFileName() == null) continue;
                file = new File(modFile.fileName);
            } else {
                file = new File(modFile.folderName, modFile.fileName);
            }
            String path = file.toString();
            foundAny = true;
            if (File.separatorChar == '\\') {
                path = path.replace('\\', '/');
            }
            boolean useThisFile = true;
            Iterator<GlobFilenameFilter> iterator = this.ignoreFiles.iterator();
            while (iterator.hasNext() && useThisFile) {
                GlobFilenameFilter pattern = iterator.next();
                if (!pattern.accept(file, path)) continue;
                useThisFile = false;
            }
            if (!useThisFile) continue;
            return false;
        }
        return foundAny;
    }

    public Date getTimeOfCheck() {
        return this.timeOfCheck;
    }

    public boolean isModified() {
        return !this.modifications.isEmpty() || this.lieOnIsModified;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.sourceControls.isEmpty(), "modificationset element requires at least one nested source control element");
        for (SourceControl sc : this.sourceControls) {
            sc.validate();
        }
    }

    int getQuietPeriod() {
        return this.quietPeriod;
    }

    public void setRequireModification(boolean isModifiedAccurate) {
        LOG.warn((Object)"<modificationset requiremodification=\"true|false\" is deprecated. Use <project requiremodification=\"true|false\".");
        this.lieOnIsModified = !isModifiedAccurate;
    }
}

