/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.util.DateUtil;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modification
implements Comparable,
Serializable {
    private static final long serialVersionUID = 6102576575583133520L;
    private static final Logger LOG = Logger.getLogger(Modification.class);
    private static final String TAGNAME_MODIFICATION = "modification";
    private static final String TAGNAME_TYPE = "type";
    private static final String TAGNAME_FILE = "file";
    private static final String TAGNAME_FILENAME = "filename";
    private static final String TAGNAME_FOLDERNAME = "project";
    private static final String TAGNAME_DATE = "date";
    private static final String TAGNAME_USER = "user";
    private static final String TAGNAME_COMMENT = "comment";
    private static final String TAGNAME_EMAIL = "email";
    private static final String TAGNAME_REVISION = "revision";
    private static final String TAGNAME_ACTION = "action";
    public String type = "";
    public String userName = "";
    public String comment = "";
    public String emailAddress;
    public String revision;
    public Date modifiedTime;
    public List<ModifiedFile> files = new ArrayList<ModifiedFile>();

    public Modification() {
        this("unknown");
    }

    public Modification(String type) {
        this.type = type;
    }

    public Modification(String type, String user, String comment, String email, Date datetime, String revision, List<ModifiedFile> files) {
        this.type = type;
        this.userName = user;
        this.comment = comment;
        this.emailAddress = email;
        this.modifiedTime = datetime;
        this.revision = revision;
        this.files = files;
    }

    public final ModifiedFile createModifiedFile(String filename, String folder) {
        ModifiedFile file = new ModifiedFile(filename, "", folder, "unknown");
        this.files.add(file);
        return file;
    }

    public Element toElement() {
        CDATA cd;
        Element modificationElement = new Element(TAGNAME_MODIFICATION);
        modificationElement.setAttribute(TAGNAME_TYPE, this.type);
        for (ModifiedFile file : this.files) {
            modificationElement.addContent((Content)file.toElement());
        }
        Element dateElement = new Element(TAGNAME_DATE);
        dateElement.addContent(DateUtil.formatIso8601(this.modifiedTime));
        Element userElement = new Element(TAGNAME_USER);
        userElement.addContent(this.userName);
        Element commentElement = new Element(TAGNAME_COMMENT);
        try {
            cd = new CDATA(this.comment);
        }
        catch (IllegalDataException e) {
            LOG.error((Object)e);
            cd = new CDATA("Unable to parse comment.  It contains illegal data.");
        }
        commentElement.addContent((Content)cd);
        modificationElement.addContent((Content)dateElement);
        modificationElement.addContent((Content)userElement);
        modificationElement.addContent((Content)commentElement);
        if (this.revision != null && this.revision.trim().length() > 0) {
            Element revisionElement = new Element(TAGNAME_REVISION);
            revisionElement.addContent(this.revision);
            modificationElement.addContent((Content)revisionElement);
        }
        if (this.emailAddress != null) {
            Element emailAddressElement = new Element(TAGNAME_EMAIL);
            emailAddressElement.addContent(this.emailAddress);
            modificationElement.addContent((Content)emailAddressElement);
        }
        return modificationElement;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Type: ").append(this.type).append('\n');
        sb.append("Last Modified: ").append(DateUtil.formatIso8601(this.modifiedTime)).append('\n');
        sb.append("Revision: ").append(this.revision).append('\n');
        sb.append("UserName: ").append(this.userName).append('\n');
        sb.append("EmailAddress: ").append(this.emailAddress).append('\n');
        sb.append("Comment: ").append(this.comment).append('\n');
        return sb.toString();
    }

    public void log() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Type: " + this.type));
            LOG.debug((Object)("Last Modified: " + DateUtil.formatIso8601(this.modifiedTime)));
            LOG.debug((Object)("UserName: " + this.userName));
            LOG.debug((Object)("EmailAddress: " + this.emailAddress));
            LOG.debug((Object)("Comment: " + this.comment));
            LOG.debug((Object)"");
        }
    }

    public String getFileName() {
        if (this.files.isEmpty()) {
            return null;
        }
        return this.files.get((int)0).fileName;
    }

    public String getFolderName() {
        if (this.files.isEmpty()) {
            return null;
        }
        return this.files.get((int)0).folderName;
    }

    public List<ModifiedFile> getModifiedFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public int compareTo(Object o) {
        Modification modification = (Modification)o;
        return this.modifiedTime.compareTo(modification.modifiedTime);
    }

    public boolean equals(Object o) {
        boolean emailsAreEqual;
        if (!(o instanceof Modification)) {
            return false;
        }
        Modification mod = (Modification)o;
        boolean bl = this.emailAddress != null ? this.emailAddress.equals(mod.emailAddress) : (emailsAreEqual = mod.emailAddress == null);
        boolean revisionsAreEqual = this.revision != null ? this.revision.equals(mod.revision) : mod.revision == null;
        boolean filesAreEqual = this.files.size() == mod.files.size();
        for (int i = 0; filesAreEqual && i < this.files.size(); ++i) {
            filesAreEqual = mod.files.get(i).equals(this.files.get(i));
        }
        return this.type.equals(mod.type) && this.modifiedTime.equals(mod.modifiedTime) && this.userName.equals(mod.userName) && revisionsAreEqual && emailsAreEqual && this.comment.equals(mod.comment);
    }

    public int hashCode() {
        int code = 1;
        if (this.type != null) {
            code += this.type.hashCode() * 2;
        }
        if (this.modifiedTime != null) {
            code = (int)((long)code + this.modifiedTime.getTime());
        }
        if (this.userName != null) {
            code += this.userName.hashCode() * 5;
        }
        if (this.emailAddress != null) {
            code += this.emailAddress.hashCode() * 7;
        }
        if (this.comment != null) {
            code += this.comment.hashCode() * 11;
        }
        if (this.revision != null) {
            code += this.revision.hashCode() * 13;
        }
        if (this.files != null) {
            code += this.fileHashComponent();
        }
        return code;
    }

    private int fileHashComponent() {
        int code = 1;
        for (ModifiedFile file : this.files) {
            code += file.hashCode();
        }
        return code;
    }

    public void fromElement(Element modification) {
        this.type = modification.getAttributeValue(TAGNAME_TYPE);
        try {
            String s = modification.getChildText(TAGNAME_DATE);
            if (s == null) {
                XMLOutputter outputter = new XMLOutputter();
                LOG.info((Object)("XML: " + outputter.outputString(modification)));
            }
            this.modifiedTime = DateUtil.parseIso8601(s);
        }
        catch (ParseException e) {
            LOG.warn((Object)"exception parsing date from Modification Element", (Throwable)e);
            this.modifiedTime = new Date();
        }
        this.revision = modification.getChildText(TAGNAME_REVISION);
        this.userName = modification.getChildText(TAGNAME_USER);
        this.comment = modification.getChildText(TAGNAME_COMMENT);
        this.emailAddress = modification.getChildText(TAGNAME_EMAIL);
        this.files.clear();
        List modfiles = modification.getChildren(TAGNAME_FILE);
        if (modfiles != null && modfiles.size() > 0) {
            for (Element modfileElement : modfiles) {
                ModifiedFile modfile = new ModifiedFile(modfileElement);
                this.files.add(modfile);
            }
        }
    }

    public String getFullPath() {
        StringBuffer result = new StringBuffer();
        String folderName = this.getFolderName();
        if (folderName != null) {
            result.append(folderName).append("/");
        }
        result.append(this.getFileName());
        return result.toString().replace('\\', '/');
    }

    public String getType() {
        return this.type;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getComment() {
        return this.comment;
    }

    public static class ModifiedFile {
        public String fileName;
        public String revision;
        public String folderName;
        public String action = "unknown";

        public ModifiedFile(String fileName, String revision, String folderName, String action) {
            this.fileName = fileName;
            this.revision = revision;
            this.folderName = folderName;
            this.action = action;
        }

        public ModifiedFile(Element modification) {
            this.fileName = modification.getChildText(Modification.TAGNAME_FILENAME);
            this.folderName = modification.getChildText(Modification.TAGNAME_FOLDERNAME);
            this.revision = modification.getChildText(Modification.TAGNAME_REVISION);
            this.action = modification.getAttributeValue(Modification.TAGNAME_ACTION);
        }

        public Element toElement() {
            Element element = new Element(Modification.TAGNAME_FILE);
            if (this.revision != null && this.revision.trim().length() > 0) {
                Element revisionElement = new Element(Modification.TAGNAME_REVISION);
                revisionElement.addContent(this.revision);
                element.addContent((Content)revisionElement);
            }
            if (this.action != null && this.action.trim().length() > 0) {
                element.setAttribute(Modification.TAGNAME_ACTION, this.action);
            }
            Element fileElement = new Element(Modification.TAGNAME_FILENAME);
            fileElement.addContent(this.fileName);
            element.addContent((Content)fileElement);
            if (this.folderName != null && this.folderName.trim().length() > 0) {
                Element folderElement = new Element(Modification.TAGNAME_FOLDERNAME);
                folderElement.addContent(this.folderName);
                element.addContent((Content)folderElement);
            }
            return element;
        }

        public boolean equals(Object o) {
            boolean folderNamesAreEqual;
            if (!(o instanceof ModifiedFile)) {
                return false;
            }
            ModifiedFile mod = (ModifiedFile)o;
            boolean bl = this.folderName != null ? this.folderName.equals(mod.folderName) : (folderNamesAreEqual = mod.folderName == null);
            boolean revisionsAreEqual = this.revision != null ? this.revision.equals(mod.revision) : mod.revision == null;
            return this.action.equals(mod.action) && this.fileName.equals(mod.fileName) && folderNamesAreEqual && revisionsAreEqual;
        }

        public int hashCode() {
            int code = 1;
            if (this.fileName != null) {
                code += this.fileName.hashCode() * 2;
            }
            if (this.revision != null) {
                code += this.revision.hashCode() * 3;
            }
            if (this.folderName != null) {
                code += this.folderName.hashCode() * 5;
            }
            if (this.action != null) {
                code += this.action.hashCode() * 7;
            }
            return code;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getAction() {
            return this.action;
        }
    }
}

