/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.jmx.CruiseControlControllerAgent;
import net.sourceforge.cruisecontrol.launch.CruiseControlMain;
import net.sourceforge.cruisecontrol.report.BuildLoopMonitorRepository;
import net.sourceforge.cruisecontrol.report.BuildLoopPostingConfiguration;
import net.sourceforge.cruisecontrol.util.MainArgs;
import net.sourceforge.cruisecontrol.util.threadpool.ThreadQueueProperties;
import net.sourceforge.cruisecontrol.web.EmbeddedJettyServer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class Main
implements CruiseControlMain {
    private static final Logger LOG = Logger.getLogger(Main.class);
    private static final String DEFAULT_NAME = "";
    private static final String DEFAULT_WEBAPP_PATH = "/webapps/cruisecontrol";
    private static final String DEFAULT_DASHBOARD_PATH = "/webapps/dashboard";
    private static final int DEFAULT_WEB_PORT = 8080;
    private static final int DEFAULT_INTERVAL = 5;
    private static final boolean DEFAULT_POSTING_ENABLED = true;
    private CruiseControlController controller;
    private CruiseControlControllerAgent agent;
    static final String SYSPROP_CCMAIN_SKIP_USAGE = "cc.main.skip.usage";

    public static void main(String[] args) {
        boolean normalExit = new Main().start(args);
        if (!normalExit) {
            System.exit(1);
        }
    }

    public boolean start(String[] args) {
        Properties versionProperties = Main.getBuildVersionProperties();
        Main.printVersion(versionProperties);
        if (Main.shouldPrintUsage(args)) {
            Main.printUsage();
            return false;
        }
        try {
            Main.checkDeprecatedArguments(args, LOG);
            if (MainArgs.findIndex(args, "debug") != -1) {
                Logger.getRootLogger().setLevel(Level.DEBUG);
            }
            this.controller = this.createController(args, versionProperties);
            if (Main.shouldStartJmxAgent(args)) {
                this.startJmxAgent(args);
            }
            if (Main.shouldStartEmbeddedServer(args)) {
                this.startEmbeddedServer(args);
            }
            if (Main.shouldPostDataToDashboard(args)) {
                this.startPostingToDashboard(args);
            }
            Main.parseCCName(args);
            this.controller.resume();
        }
        catch (CruiseControlException e) {
            LOG.fatal((Object)e.getMessage());
            Main.printUsage();
            return false;
        }
        return true;
    }

    private void startJmxAgent(String[] args) {
        this.agent = new CruiseControlControllerAgent(this.controller, Main.parseJMXHttpPort(args), Main.parseRmiPort(args), Main.parseUser(args), Main.parsePassword(args), Main.parseXslPath(args), Main.parseEnableJMXAgentUtility(args));
        this.agent.start();
    }

    private CruiseControlController createController(String[] args, Properties versionProperties) throws CruiseControlException {
        CruiseControlController ccController = new CruiseControlController();
        ccController.setVersionProperties(versionProperties);
        File configFile = new File(Main.parseConfigFileName(args, "config.xml"));
        try {
            ccController.setConfigFile(configFile);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"error setting config file on controller", (Throwable)e);
            throw e;
        }
        int maxNbThreads = ccController.getConfigManager().getCruiseControlConfig().getMaxNbThreads();
        ThreadQueueProperties.setMaxThreadCount(maxNbThreads);
        return ccController;
    }

    void startEmbeddedServer(String[] args) throws CruiseControlException {
        String configFileName = Main.parseConfigFileName(args, "config.xml");
        int jmxPort = Main.parseJMXHttpPort(args);
        int rmiPort = Main.parseRmiPort(args);
        this.setUpSystemPropertiesForDashboard(configFileName, jmxPort, rmiPort);
        String ccHome = System.getProperty("cc.home", ".");
        System.setProperty("jetty.home", ccHome);
        File jettyXml = new File(Main.parseJettyXml(args, ccHome));
        EmbeddedJettyServer embeddedJettyServer = new EmbeddedJettyServer(jettyXml, Main.parseWebPort(args));
        embeddedJettyServer.start();
    }

    private void setUpSystemPropertiesForDashboard(String configFileName, int jmxPort, int rmiPort) {
        if (configFileName != null) {
            File configFile = new File(configFileName);
            if (!configFile.exists()) {
                throw new RuntimeException("Cannot find config file at " + configFile.getAbsolutePath());
            }
            System.setProperty("cc.config.file", configFile.getAbsolutePath());
        }
        System.setProperty("cc.rmiport", String.valueOf(rmiPort));
        System.setProperty("cc.jmxport", String.valueOf(jmxPort));
    }

    static void checkDeprecatedArguments(String[] args, Logger logger) {
        if (MainArgs.findIndex(args, "port") != -1) {
            logger.warn((Object)"WARNING: The port argument is deprecated. Use jmxport instead.");
        }
    }

    public static void printUsage() {
        if (Boolean.getBoolean(SYSPROP_CCMAIN_SKIP_USAGE)) {
            return;
        }
        System.out.println(DEFAULT_NAME);
        System.out.println("Usage:");
        System.out.println(DEFAULT_NAME);
        System.out.println("Starts a continuous integration loop");
        System.out.println(DEFAULT_NAME);
        System.out.println("cruisecontrol [options]");
        System.out.println(DEFAULT_NAME);
        System.out.println("Build loop options are:");
        System.out.println(DEFAULT_NAME);
        System.out.println("  -configfile file     configuration file; default config.xml");
        System.out.println("  -debug               set logging level to DEBUG");
        System.out.println("  -log4jconfig url     URL to a log4j config (example: \"file:/c:/mylog4j.xml\")");
        System.out.println("  -? or -help          print this usage message");
        System.out.println(DEFAULT_NAME);
        System.out.println("Options when using JMX");
        System.out.println("  Note: JMX server only started if -jmxport and/or -rmiport specified");
        System.out.println("  -jmxport [number]       port of the JMX HttpAdapter; default 8000");
        System.out.println("  -rmiport [number]       RMI port of the Controller; default 1099");
        System.out.println("  -user username          username for HttpAdapter; default no login required");
        System.out.println("  -password pwd           password for HttpAdapter; default no login required");
        System.out.println("  -xslpath directory      location of jmx xsl files; default files in package");
        System.out.println("  -agentutil [true/false] load JMX Build Agent utility; default is true");
        System.out.println(DEFAULT_NAME);
        System.out.println("Options when using embedded Jetty");
        System.out.println("  -webport [number]       port for the Reporting website; default 8080, removing");
        System.out.println("                          this propery will make cruisecontrol start without Jetty");
        System.out.println("  -jettyxml file          Jetty configuration xml. Defaults to jetty.xml");
        System.out.println("  -postenabled enabled    switch of posting current build information to dashboard");
        System.out.println("                          default is true");
        System.out.println("  -dashboardurl url       the url for dashboard (used for posting build information)");
        System.out.println("                          default is http://localhost:8080/dashboard");
        System.out.println("  -postinterval interval  how frequently build information will be posted to dashboard");
        System.out.println("                          default is 5 (in second).");
        System.out.println("  -ccname name            A logical name which will be displayed in the");
        System.out.println("                          Reporting Application's status page.");
        System.out.println(DEFAULT_NAME);
    }

    static String parseCCName(String[] args) {
        String theCCName = MainArgs.parseArgument(args, "ccname", DEFAULT_NAME, DEFAULT_NAME);
        System.setProperty("ccname", theCCName);
        return theCCName;
    }

    static boolean shouldPostDataToDashboard(String[] args) {
        return Main.parseHttpPostingEnabled(args) && BuildLoopMonitorRepository.getBuildLoopMonitor() == null;
    }

    public void startPostingToDashboard(String[] args) {
        String url = Main.parseDashboardUrl(args);
        long interval = Main.parseHttpPostingInterval(args);
        BuildLoopMonitorRepository.cancelExistingAndStartNewPosting(this.controller, new BuildLoopPostingConfiguration(url, interval));
    }

    static int parseWebPort(String[] args) {
        return MainArgs.parseInt(args, "webport", 8080, 8080);
    }

    String parseWebappPath(String[] args) {
        String webappPath = MainArgs.parseArgument(args, "webapppath", this.getDefaultWebAppPath(), this.getDefaultWebAppPath());
        if (webappPath != null) {
            Main.validateWebAppPath(webappPath, "webapppath");
        }
        return webappPath;
    }

    private String getDefaultWebAppPath() {
        return System.getProperty("cc.home", ".") + DEFAULT_WEBAPP_PATH;
    }

    private static String getDefaultDashboardPath() {
        return System.getProperty("cc.home", ".") + DEFAULT_DASHBOARD_PATH;
    }

    static String parseDashboardPath(String[] args) {
        String dashboardPath = MainArgs.parseArgument(args, "dashboard", Main.getDefaultDashboardPath(), Main.getDefaultDashboardPath());
        if (dashboardPath != null) {
            Main.validateWebAppPath(dashboardPath, "dashboard");
        }
        return dashboardPath;
    }

    private static void validateWebAppPath(String webappPath, String path) {
        File directory = new File(webappPath);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' argument must specify an existing directory but was " + webappPath);
        }
        directory = new File(webappPath, "WEB-INF");
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' argument must point to an exploded web app.  " + "No WEB-INF directory exists for: " + webappPath);
        }
    }

    static String parseConfigFileName(String[] args, String configFileName) throws CruiseControlException {
        if ((configFileName = MainArgs.parseArgument(args, "configfile", configFileName, null)) == null) {
            throw new CruiseControlException("'configfile' is a required argument to CruiseControl.");
        }
        return configFileName;
    }

    static String parseJettyXml(String[] args, String ccHome) {
        boolean nullOrEmpty = ccHome == null || ccHome.length() == 0;
        String defaultJettyXml = nullOrEmpty ? "etc/jetty.xml" : ccHome + "/etc/jetty.xml";
        return MainArgs.parseArgument(args, "jettyxml", defaultJettyXml, defaultJettyXml);
    }

    static boolean shouldStartJmxAgent(String[] args) {
        return MainArgs.argumentPresent(args, "jmxport") || MainArgs.argumentPresent(args, "rmiport") || MainArgs.argumentPresent(args, "port");
    }

    static boolean shouldStartEmbeddedServer(String[] args) {
        return MainArgs.argumentPresent(args, "webport") || MainArgs.argumentPresent(args, "webapppath");
    }

    static int parseJMXHttpPort(String[] args) {
        if (MainArgs.argumentPresent(args, "jmxport") && MainArgs.argumentPresent(args, "port")) {
            throw new IllegalArgumentException("'jmxport' and 'port' arguments are not valid together. Use 'jmxport' instead.");
        }
        if (MainArgs.argumentPresent(args, "jmxport")) {
            return MainArgs.parseInt(args, "jmxport", -1, 8000);
        }
        return MainArgs.parseInt(args, "port", -1, 8000);
    }

    static int parseRmiPort(String[] args) {
        return MainArgs.parseInt(args, "rmiport", -1, 1099);
    }

    static String parseXslPath(String[] args) {
        File directory;
        String xslpath = MainArgs.parseArgument(args, "xslpath", null, null);
        if (xslpath != null && !(directory = new File(xslpath)).isDirectory()) {
            throw new IllegalArgumentException("'xslpath' argument must specify an existing directory but was " + xslpath);
        }
        return xslpath;
    }

    static CruiseControlControllerAgent.LOAD_JMX_AGENTUTIL parseEnableJMXAgentUtility(String[] args) {
        if (!MainArgs.argumentPresent(args, "agentutil")) {
            return CruiseControlControllerAgent.LOAD_JMX_AGENTUTIL.LOAD_IF_AVAILABLE;
        }
        if (MainArgs.parseBoolean(args, "agentutil", false, true)) {
            return CruiseControlControllerAgent.LOAD_JMX_AGENTUTIL.FORCE_LOAD;
        }
        return CruiseControlControllerAgent.LOAD_JMX_AGENTUTIL.FORCE_BYPASS;
    }

    static String parsePassword(String[] args) {
        return MainArgs.parseArgument(args, "password", null, null);
    }

    static String parseUser(String[] args) {
        return MainArgs.parseArgument(args, "user", null, null);
    }

    private static Properties getBuildVersionProperties() {
        Properties props = new Properties();
        try {
            props.load(Main.class.getResourceAsStream("/version.properties"));
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading version properties", (Throwable)e);
        }
        return props;
    }

    private static void printVersion(Properties props) {
        LOG.info((Object)("CruiseControl Version " + props.getProperty("version") + " " + props.getProperty("version.info")));
    }

    static boolean shouldPrintUsage(String[] args) {
        return MainArgs.findIndex(args, "?") != -1 || MainArgs.findIndex(args, "help") != -1;
    }

    public void stop() {
        this.controller.pause();
        this.agent.stop();
    }

    public static String parseDashboardUrl(String[] args) {
        int webport = Main.parseWebPort(args);
        return MainArgs.parseArgument(args, "dashboardurl", Main.defaultDashboardUrl(webport), Main.defaultDashboardUrl(8080));
    }

    private static String defaultDashboardUrl(int port) {
        return "http://localhost:" + port + "/dashboard";
    }

    public static long parseHttpPostingInterval(String[] args) {
        return MainArgs.parseInt(args, "postinterval", 5, 5);
    }

    public static boolean parseHttpPostingEnabled(String[] args) {
        return MainArgs.parseBoolean(args, "postenabled", true, true);
    }
}

