/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.BuildLogger;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Manipulator;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Log
implements Serializable {
    private static final long serialVersionUID = -5727569770074024691L;
    private static final Logger LOG = Logger.getLogger(Log.class);
    public static final int BEFORE_LENGTH = "logYYYYMMDDhhmmssL".length();
    private static final int AFTER_LENGTH = ".xml".length();
    private transient String logDir;
    private transient String logXmlEncoding;
    private transient Element buildLog;
    private final transient List<BuildLogger> loggers = new ArrayList<BuildLogger>();
    private final transient List<Manipulator> manipulators = new ArrayList<Manipulator>();
    private transient String projectName;

    public Log() {
        this.reset();
    }

    void setProjectName(String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("projectName can't be null");
        }
        this.projectName = projectName;
        if (this.logDir == null) {
            this.logDir = "logs" + File.separatorChar + projectName;
        }
    }

    public void validate() throws CruiseControlException {
        if (this.projectName == null) {
            throw new CruiseControlException("projectName must be set");
        }
        if (this.logDir != null) {
            this.checkLogDirectory(this.logDir);
        }
        for (BuildLogger logger : this.loggers) {
            logger.validate();
        }
        for (Manipulator manipulator : this.manipulators) {
            manipulator.validate();
        }
    }

    public void add(BuildLogger logger) {
        this.loggers.add(logger);
    }

    public void add(Manipulator manipulator) {
        this.manipulators.add(manipulator);
    }

    public BuildLogger[] getLoggers() {
        return this.loggers.toArray(new BuildLogger[this.loggers.size()]);
    }

    public String getLogXmlEncoding() {
        return this.logXmlEncoding;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setLogDir(String logDir) throws CruiseControlException {
        this.setDir(logDir);
    }

    public void setDir(String logDir) throws CruiseControlException {
        this.logDir = logDir;
    }

    public void setLogXmlEncoding(String logXmlEncoding) {
        this.setEncoding(logXmlEncoding);
    }

    public void setEncoding(String logXmlEncoding) {
        this.logXmlEncoding = logXmlEncoding;
    }

    public String getLogDir() {
        return this.logDir;
    }

    private void checkLogDirectory(String logDir) throws CruiseControlException {
        File logDirectory = new File(logDir);
        if (!logDirectory.exists()) {
            LOG.info((Object)("log directory specified in config file does not exist; creating: " + logDirectory.getAbsolutePath()));
            if (!Util.doMkDirs(logDirectory)) {
                throw new CruiseControlException("Can't create log directory specified in config file: " + logDirectory.getAbsolutePath());
            }
        } else if (!logDirectory.isDirectory()) {
            throw new CruiseControlException("Log directory specified in config file is not a directory: " + logDirectory.getAbsolutePath());
        }
    }

    public void writeLogFile(Date now) throws CruiseControlException {
        for (BuildLogger nextLogger : this.loggers) {
            nextLogger.log(this.buildLog);
        }
        String logFilename = this.decideLogfileName(now);
        Element logDirElement = new Element("property");
        logDirElement.setAttribute("name", "logdir");
        logDirElement.setAttribute("value", new File(this.logDir).getAbsolutePath());
        this.buildLog.getChild("info").addContent((Content)logDirElement);
        Element logFileElement = new Element("property");
        logFileElement.setAttribute("name", "logfile");
        logFileElement.setAttribute("value", logFilename);
        this.buildLog.getChild("info").addContent((Content)logFileElement);
        File logfile = new File(this.logDir, logFilename);
        LOG.debug((Object)("Project " + this.projectName + ":  Writing log file [" + logfile.getAbsolutePath() + "]"));
        this.writeLogFile(logfile, this.buildLog);
        this.callManipulators();
    }

    protected void writeLogFile(File file, Element element) throws CruiseControlException {
        BufferedOutputStream logStream = null;
        try {
            Format format = Format.getPrettyFormat();
            if (this.logXmlEncoding != null) {
                format.setEncoding(this.logXmlEncoding);
            }
            XMLOutputter outputter = new XMLOutputter(format);
            logStream = new BufferedOutputStream(new FileOutputStream(file));
            outputter.output(new Document(element), (OutputStream)logStream);
        }
        catch (IOException e) {
            try {
                throw new CruiseControlException(e);
            }
            catch (Throwable throwable) {
                IO.close(logStream);
                throw throwable;
            }
        }
        IO.close(logStream);
    }

    private String decideLogfileName(Date now) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(this.buildLog);
        if (helper.isBuildSuccessful()) {
            return Log.formatLogFileName(now, helper.getLabel());
        }
        return Log.formatLogFileName(now);
    }

    protected void callManipulators() {
        for (Manipulator manipulator : this.manipulators) {
            manipulator.execute(this.getLogDir());
        }
    }

    public static String formatLogFileName(Date date) {
        return Log.formatLogFileName(date, null);
    }

    public static String formatLogFileName(Date date, String label) {
        StringBuffer logFileName = new StringBuffer();
        logFileName.append("log");
        logFileName.append(DateUtil.getFormattedTime(date));
        if (label != null) {
            logFileName.append("L");
            logFileName.append(label);
        }
        logFileName.append(".xml");
        return logFileName.toString();
    }

    public void addContent(Content newContent) {
        this.buildLog.addContent(newContent);
    }

    public Element getContent() {
        return (Element)this.buildLog.clone();
    }

    public boolean wasBuildSuccessful() {
        return new XMLLogHelper(this.buildLog).isBuildSuccessful();
    }

    public void reset() {
        this.buildLog = new Element("cruisecontrol");
    }

    public static boolean wasSuccessfulBuild(String filename) {
        if (filename == null) {
            return false;
        }
        boolean startsWithLog = filename.startsWith("log");
        boolean hasLabelSeparator = filename.indexOf(76) == BEFORE_LENGTH - 1;
        boolean isXmlFile = filename.endsWith(".xml");
        return startsWithLog && hasLabelSeparator && isXmlFile;
    }

    public static Date parseDateFromLogFileName(String filename) throws CruiseControlException {
        return DateUtil.parseFormattedTime(filename.substring(3, BEFORE_LENGTH - 1), "date from logfile name");
    }

    public static String parseLabelFromLogFileName(String filename) {
        if (!Log.wasSuccessfulBuild(filename)) {
            return "";
        }
        return filename.substring(BEFORE_LENGTH, filename.length() - AFTER_LENGTH);
    }
}

