/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.cruisecontrol.BuildQueue;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.PluginDetail;
import net.sourceforge.cruisecontrol.PluginRegistry;
import net.sourceforge.cruisecontrol.PluginType;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.config.XMLConfigManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CruiseControlController {
    private static final Logger LOG = Logger.getLogger(CruiseControlController.class);
    public static final String DEFAULT_CONFIG_FILE_NAME = "config.xml";
    private File configFile;
    private final List<ProjectInterface> projects = new ArrayList<ProjectInterface>();
    private final BuildQueue buildQueue = new BuildQueue();
    private Properties versionProperties;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private XMLConfigManager configManager;
    private final ParsingConfigMutex parsingConfigMutex = new ParsingConfigMutex();
    private static final PluginDetail[] EMPTY_PLUGIN_DETAIL = new PluginDetail[0];

    public CruiseControlController() {
        this.buildQueue.addListener(new BuildQueueListener());
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setVersionProperties(Properties versionProperties) {
        this.versionProperties = versionProperties;
    }

    public Properties getVersionProperties() {
        return this.versionProperties;
    }

    public void setConfigFile(File configFile) throws CruiseControlException {
        if (configFile == null) {
            throw new CruiseControlException("No config file");
        }
        if (!configFile.isFile()) {
            throw new CruiseControlException("Config file not found: " + configFile.getAbsolutePath());
        }
        if (!configFile.equals(this.configFile)) {
            this.configFile = configFile;
            this.configManager = new XMLConfigManager(configFile, this);
        }
        this.loadConfig();
    }

    private void addProject(ProjectInterface project) throws CruiseControlException {
        project.configureProject();
        this.projects.add(project);
        for (Listener listener : this.listeners) {
            LOG.debug((Object)("Informing listener of added project " + project.getName()));
            listener.projectAdded(project);
        }
        project.setBuildQueue(this.buildQueue);
        project.start();
    }

    private void removeProject(ProjectInterface project) {
        this.projects.remove(project);
        for (Listener listener : this.listeners) {
            LOG.debug((Object)("Informing listener of removed project " + project.getName()));
            listener.projectRemoved(project);
        }
        project.stop();
    }

    public void resume() {
        this.buildQueue.start();
        for (ProjectInterface currentProject : this.projects) {
            currentProject.setBuildQueue(this.buildQueue);
            currentProject.start();
        }
    }

    public void pause() {
        this.buildQueue.stop();
        for (ProjectInterface currentProject : this.projects) {
            currentProject.stop();
        }
    }

    public void halt() {
        this.pause();
        System.exit(0);
    }

    public String getBuildQueueStatus() {
        if (this.buildQueue.isAlive()) {
            if (this.buildQueue.isWaiting()) {
                return "waiting";
            }
            return "alive";
        }
        return "dead";
    }

    public List<ProjectInterface> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    private List<ProjectInterface> getAllProjects(XMLConfigManager configManager) {
        Set<String> projectNames = configManager.getCruiseControlConfig().getProjectNames();
        ArrayList<ProjectInterface> allProjects = new ArrayList<ProjectInterface>(projectNames.size());
        for (String projectName : projectNames) {
            LOG.info((Object)("projectName = [" + projectName + "]"));
            ProjectInterface projectConfig = this.getConfigManager().getProject(projectName);
            allProjects.add(projectConfig);
        }
        if (allProjects.size() == 0) {
            LOG.warn((Object)"no projects found in config file");
        }
        return allProjects;
    }

    protected XMLConfigManager getConfigManager() {
        return this.configManager;
    }

    public void addListener(Listener listener) {
        LOG.debug((Object)"Listener added");
        this.listeners.add(listener);
    }

    public void reloadConfigFile() {
        LOG.debug((Object)"reload config file called");
        this.parseConfigFileIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseConfigFileIfNecessary() {
        boolean reloaded = false;
        if (this.parsingConfigMutex.getPermissionToParse()) {
            try {
                try {
                    reloaded = this.configManager.reloadIfNecessary();
                }
                catch (CruiseControlException e) {
                    LOG.error((Object)("error parsing config file " + this.configFile.getAbsolutePath()), (Throwable)e);
                    boolean bl = reloaded;
                    this.parsingConfigMutex.doneParsing();
                    return bl;
                }
                if (reloaded) {
                    LOG.debug((Object)"config file changed");
                    this.loadConfig();
                } else {
                    LOG.debug((Object)"config file didn't change.");
                }
            }
            finally {
                this.parsingConfigMutex.doneParsing();
            }
        }
        return reloaded;
    }

    private void loadConfig() {
        try {
            List<ProjectInterface> projectsFromFile = this.getAllProjects(this.configManager);
            ArrayList<ProjectInterface> removedProjects = new ArrayList<ProjectInterface>(this.projects);
            removedProjects.removeAll(projectsFromFile);
            ArrayList<ProjectInterface> newProjects = new ArrayList<ProjectInterface>(projectsFromFile);
            newProjects.removeAll(this.projects);
            ArrayList<ProjectInterface> retainedProjects = new ArrayList<ProjectInterface>(this.projects);
            retainedProjects.removeAll(removedProjects);
            for (ProjectInterface removedProject : removedProjects) {
                this.removeProject(removedProject);
            }
            for (ProjectInterface newProject : newProjects) {
                this.addProject(newProject);
            }
            for (ProjectInterface retainedProject : retainedProjects) {
                this.updateProject(retainedProject);
            }
        }
        catch (CruiseControlException e) {
            LOG.error((Object)("error parsing config file " + this.configFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private void updateProject(ProjectInterface oldProject) throws CruiseControlException {
        ProjectInterface newProject = this.getConfigManager().getProject(oldProject.getName());
        this.projects.remove(oldProject);
        newProject.getStateFromOldProject(oldProject);
        this.projects.add(newProject);
    }

    public PluginDetail[] getAvailableBootstrappers() {
        return CruiseControlController.getPluginsByType(this.getAvailablePlugins(), PluginType.BOOTSTRAPPER);
    }

    public PluginDetail[] getAvailablePublishers() {
        return CruiseControlController.getPluginsByType(this.getAvailablePlugins(), PluginType.PUBLISHER);
    }

    public PluginDetail[] getAvailableSourceControls() {
        return CruiseControlController.getPluginsByType(this.getAvailablePlugins(), PluginType.SOURCE_CONTROL);
    }

    public PluginDetail[] getAvailablePlugins() {
        try {
            return this.getPluginRegistry().getPluginDetails();
        }
        catch (CruiseControlException e) {
            return EMPTY_PLUGIN_DETAIL;
        }
    }

    public PluginType[] getAvailablePluginTypes() {
        return this.getPluginRegistry().getPluginTypes();
    }

    public PluginRegistry getPluginRegistry() {
        return this.configManager.getCruiseControlConfig().getRootPlugins();
    }

    private static PluginDetail[] getPluginsByType(PluginDetail[] details, PluginType type) {
        ArrayList<PluginDetail> plugins = new ArrayList<PluginDetail>();
        for (PluginDetail detail : details) {
            if (!detail.getType().equals(type)) continue;
            plugins.add(detail);
        }
        return plugins.toArray(new PluginDetail[plugins.size()]);
    }

    private class ParsingConfigMutex {
        private final Object mutex = new Object();
        private boolean inUse;

        private ParsingConfigMutex() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getPermissionToParse() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.inUse) {
                    LOG.debug((Object)"permission denied to parse config");
                    return false;
                }
                this.inUse = true;
                LOG.debug((Object)"permission granted to parse config");
                return true;
            }
        }

        void doneParsing() {
            LOG.debug((Object)"done parsing, allow next request permission to parse");
            this.inUse = false;
        }
    }

    private class BuildQueueListener
    implements BuildQueue.Listener {
        private BuildQueueListener() {
        }

        public void buildRequested() {
            CruiseControlController.this.parseConfigFileIfNecessary();
        }
    }

    public static interface Listener
    extends EventListener {
        public void projectAdded(ProjectInterface var1);

        public void projectRemoved(ProjectInterface var1);
    }
}

