/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.util.PerDayScheduleItem;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Builder
extends PerDayScheduleItem
implements Comparable {
    private int time = -1;
    private int multiple = 1;
    private boolean multipleSet = false;
    private boolean showProgress = true;

    public abstract Element build(Map<String, String> var1, Progress var2) throws CruiseControlException;

    public abstract Element buildWithTarget(Map<String, String> var1, String var2, Progress var3) throws CruiseControlException;

    public void validate() throws CruiseControlException {
        boolean timeSet;
        boolean bl = timeSet = this.time != -1;
        if (timeSet) {
            ValidationHelper.assertFalse(this.time < 0, "negative values for time are not allowed");
        }
        ValidationHelper.assertFalse(timeSet && this.multipleSet, "Only one of 'time' or 'multiple' are allowed on builders.");
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(String timeString) {
        this.time = Integer.parseInt(timeString);
    }

    public void setMultiple(int multiple) {
        this.multipleSet = multiple != -1;
        this.multiple = multiple;
    }

    public int getMultiple() {
        boolean timeSet;
        boolean bl = timeSet = this.time != -1;
        if (timeSet && !this.multipleSet) {
            return -1;
        }
        return this.multiple;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public boolean isValidDay(Date now) {
        if (this.getDay() < 0) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        return cal.get(7) == this.getDay();
    }

    public int compareTo(Object o) {
        Builder builder = (Builder)o;
        Integer integer = new Integer(this.multiple);
        Integer integer2 = new Integer(builder.getMultiple());
        return integer2.compareTo(integer);
    }

    public boolean isTimeBuilder() {
        return this.time != -1;
    }
}

