/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.ProjectWrapper;
import net.sourceforge.cruisecontrol.util.threadpool.ThreadQueue;
import org.apache.log4j.Logger;

public class BuildQueue
implements Runnable {
    private static final Logger LOG = Logger.getLogger(BuildQueue.class);
    private final LinkedList<ProjectInterface> queue = new LinkedList();
    private boolean waiting = false;
    private Thread buildQueueThread;
    private final List<Listener> listeners = new ArrayList<Listener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBuild(ProjectInterface project) {
        LOG.debug((Object)("BuildQueue.requestBuild Thread = " + Thread.currentThread().getName()));
        this.notifyListeners();
        LinkedList<ProjectInterface> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(project);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findPosition(ProjectInterface project) {
        int length;
        int position;
        LinkedList<ProjectInterface> linkedList = this.queue;
        synchronized (linkedList) {
            position = this.queue.indexOf(project);
            length = this.queue.size();
        }
        if (position < 0) {
            return ThreadQueue.findPosition(project.getName());
        }
        return "BUILD_REQUESTED[ " + (position + 1) + " / " + length + " ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceQueue() {
        LinkedList<ProjectInterface> linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.queue.isEmpty()) {
                ProjectInterface nextProject = this.queue.remove(0);
                if (nextProject == null) continue;
                LOG.info((Object)("now adding to the thread queue: " + nextProject.getName()));
                ProjectWrapper pw = new ProjectWrapper(nextProject);
                ThreadQueue.addTask(pw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            LOG.info((Object)"BuildQueue started");
            while (true) {
                LinkedList<ProjectInterface> linkedList = this.queue;
                synchronized (linkedList) {
                    while (this.queue.isEmpty()) {
                        this.waiting = true;
                        this.queue.wait();
                    }
                    this.waiting = false;
                }
                this.serviceQueue();
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"BuildQueue.run() interrupted. Stopping?", (Throwable)e);
            this.waiting = false;
            LOG.info((Object)"BuildQueue thread is no longer alive");
        }
        catch (Throwable e) {
            try {
                LOG.error((Object)"BuildQueue.run()", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.waiting = false;
                LOG.info((Object)"BuildQueue thread is no longer alive");
            }
        }
    }

    void start() {
        this.buildQueueThread = new Thread((Runnable)this, "BuildQueueThread");
        this.buildQueueThread.setDaemon(false);
        this.buildQueueThread.start();
        while (!this.buildQueueThread.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                String message = "BuildQueue.start() interrupted";
                LOG.error((Object)message, (Throwable)e);
                throw new RuntimeException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        LOG.info((Object)"Stopping BuildQueue");
        if (this.buildQueueThread != null) {
            this.buildQueueThread.interrupt();
        }
        LinkedList<ProjectInterface> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public boolean isAlive() {
        return true;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<Listener> list = this.listeners;
        synchronized (list) {
            for (Listener listener : this.listeners) {
                try {
                    listener.buildRequested();
                }
                catch (Exception e) {
                    LOG.error((Object)"exception notifying listener before project queued", (Throwable)e);
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void buildRequested();
    }
}

