/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.util.BuildInformationHelper;
import net.sourceforge.cruisecontrol.util.UniqueBuildloopIdentifier;

public class BuildLoopInformation {
    private String uuid;
    private JmxInfo jmx;
    private String servername = "";
    private String timestamp = "";
    private ProjectInfo[] projects;

    public BuildLoopInformation(ProjectInfo[] projects, JmxInfo jmxinfo, String serverName, String timestamp) {
        this.projects = projects;
        this.jmx = jmxinfo;
        this.servername = serverName;
        this.timestamp = timestamp;
        this.uuid = UniqueBuildloopIdentifier.id().toString();
    }

    public String getServerName() {
        return this.servername;
    }

    public JmxInfo getJmxInfo() {
        return this.jmx;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public ProjectInfo[] getProjects() {
        return this.projects;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toXml() {
        return new BuildInformationHelper().toXml(this);
    }

    public static class ProjectInfo {
        private String name;
        private String status;
        private String buildstarttime;
        private List modifications = new ArrayList();

        public ProjectInfo(String name, String status, String buildStartTime) {
            this.name = name;
            this.status = status;
            this.buildstarttime = buildStartTime;
        }

        public String getName() {
            return this.name;
        }

        public String getStatus() {
            return this.status;
        }

        public String getBuildStartTime() {
            return this.buildstarttime;
        }

        public List getModifications() {
            return this.modifications;
        }

        public void setModifications(List modifications) {
            this.modifications = modifications;
        }
    }

    public static class JmxInfo {
        public static final String CRUISECONTROL_RMIPORT = "cruisecontrol.rmiport";
        public static final String CRUISECONTROL_JMXPORT = "cruisecontrol.jmxport";
        public static final String JMX_HTTP_USERNAME = "jmx.http.username";
        public static final String JMX_HTTP_PASSWORD = "jmx.http.password";
        private String httpurl = "";
        private String rmiurl = "";
        private String username = System.getProperty("jmx.http.username");
        private String password = System.getProperty("jmx.http.password");

        public JmxInfo(String serverName) {
            String rmiPort;
            String httpPort = System.getProperty(CRUISECONTROL_JMXPORT);
            if (httpPort != null) {
                this.httpurl = "http://" + serverName + ":" + httpPort;
            }
            if ((rmiPort = System.getProperty(CRUISECONTROL_RMIPORT)) != null) {
                this.rmiurl = "rmi://" + serverName + ":" + rmiPort;
            }
        }

        public String getHttpAdpatorUrl() {
            return this.httpurl;
        }

        public String getRmiUrl() {
            return this.rmiurl;
        }

        public String getUserName() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.httpurl.hashCode();
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + this.rmiurl.hashCode();
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.equals((JmxInfo)obj);
        }

        private boolean equals(JmxInfo other) {
            if (!this.httpurl.equals(other.httpurl)) {
                return false;
            }
            if (!this.rmiurl.equals(other.rmiurl)) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }
    }
}

