/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ComponentStorage;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.WorkPerformer;
import org.eclipse.equinox.internal.ds.WorkThread;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.equinox.internal.util.event.Queue;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.util.threadpool.ThreadPoolManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

public class SCRManager
implements ServiceListener,
SynchronousBundleListener,
ConfigurationListener,
WorkPerformer,
PrivilegedAction {
    private Hashtable bundleToServiceComponents;
    public BundleContext bc;
    protected Queue queue;
    public static Log log;
    private Resolver resolver;
    private WorkThread workThread;
    protected boolean running = false;
    protected boolean stopped = false;
    private ServiceTracker threadPoolManagerTracker;
    private boolean hasRegisteredServiceListener = false;
    public final int ENABLE_COMPONENTS = 1;
    public final int DISABLE_COMPONENTS = 2;
    private ComponentStorage storage;
    static boolean security;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        security = false;
    }

    public SCRManager(BundleContext bc, Log log) {
        String storageClass;
        Class<?> clazz;
        this.bc = bc;
        SCRManager.log = log;
        security = Log.security();
        this.hasRegisteredServiceListener = true;
        this.queue = new Queue(10);
        if (Activator.startup) {
            Activator.timeLog(110);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.util.threadpool.ThreadPoolManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.threadPoolManagerTracker = new ServiceTracker(bc, clazz.getName(), null);
        this.threadPoolManagerTracker.open();
        if (Activator.startup) {
            Activator.timeLog(111);
        }
        this.resolver = new Resolver(this);
        if (Activator.startup) {
            Activator.timeLog(112);
        }
        bc.addBundleListener((BundleListener)this);
        if (Activator.startup) {
            Activator.timeLog(105);
        }
        if ((storageClass = bc.getProperty("scr.storage.class")) == null) {
            storageClass = "org.eclipse.equinox.internal.ds.storage.file.FileStorage";
        }
        try {
            Class<?> clazz2 = Class.forName(storageClass);
            Class[] classArray = new Class[1];
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.osgi.framework.BundleContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            this.storage = (ComponentStorage)clazz2.getConstructor(classArray).newInstance(bc);
        }
        catch (Exception e) {
            log.error("[SCR - SCRManager] could not create instance for " + storageClass, (Throwable)e);
        }
    }

    public void startIt() {
        Bundle[] bundles = this.bc.getBundles();
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                Bundle current = bundles[i];
                if (current.getState() == 32) {
                    this.startedBundle(current);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Object upEv, boolean security) {
        try {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.put(upEv);
                if (!this.running) {
                    if (this.queue.size() > 0) {
                        this.running = true;
                        this.workThread = new WorkThread(this);
                        if (security) {
                            AccessController.doPrivileged(this);
                            return;
                        }
                        ThreadPoolManager threadPool = (ThreadPoolManager)this.threadPoolManagerTracker.getService();
                        if (threadPool != null) {
                            threadPool.execute((Runnable)this.workThread, 10, "Component Resolve Thread");
                        } else {
                            new Thread((Runnable)this.workThread, "Component Resolve Thread").start();
                        }
                    }
                } else if (this.workThread.waiting > 0) {
                    this.queue.notifyAll();
                }
            }
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected exception occurred!", e);
        }
    }

    public Object run() {
        ThreadPoolManager threadPool = (ThreadPoolManager)this.threadPoolManagerTracker.getService();
        if (threadPool != null) {
            threadPool.execute((Runnable)this.workThread, 10, "Component Resolve Thread");
        } else {
            new Thread((Runnable)this.workThread, "Component Resolve Thread").start();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueBlocked() {
        this.resolver.queueBlocked();
        Queue queue = this.queue;
        synchronized (queue) {
            this.running = false;
            this.addEvent(null, security);
        }
    }

    public void enqueueWork(WorkPerformer d, int a, Object o, boolean security) {
        this.addEvent(new QueuedJob(d, a, o), security);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        this.stopped = true;
        this.disposeBundles();
        if (this.queue != null) {
            this.queue.clear();
        }
        if (this.running) {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.notify();
            }
            int counter = 0;
            while (this.running && counter < 20) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++counter;
            }
        }
        this.stopped = true;
        this.threadPoolManagerTracker.close();
        this.storage.stop();
    }

    public void serviceChanged(ServiceEvent sEv) {
        this.resolver.getEligible(sEv);
    }

    public final void bundleChanged(BundleEvent event) {
        int type;
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
            log.info("[DS perf] Started processing bundle event " + event);
        }
        if ((type = event.getType()) == 256) {
            this.stoppingBundle(event.getBundle());
        } else if (type == 2) {
            this.startedBundle(event.getBundle());
        } else if (type == 16 && Activator.DBSTORE) {
            try {
                this.storage.deleteComponentDefinitions(event.getBundle().getBundleId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            log.info("[DS perf] Processed bundle event '" + event + "' for " + start + " ms");
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (this.bundleToServiceComponents != null && !this.bundleToServiceComponents.isEmpty()) {
            this.addEvent(event, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void processConfigurationEvent(ConfigurationEvent event) {
        block17: {
            if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
                return;
            }
            start = 0L;
            try {
                if (Activator.DEBUG) {
                    Activator.log.debug(" Resolver.configurationEvent(): pid = " + event.getPid() + ", fpid = " + event.getFactoryPid(), null);
                }
                if (Activator.PERF) {
                    start = System.currentTimeMillis();
                    SCRManager.log.info("[DS perf] Started processing configuration event " + event);
                }
                pid = event.getPid();
                fpid = event.getFactoryPid();
                keys = this.bundleToServiceComponents.keys();
                while (keys.hasMoreElements()) {
                    if (Activator.DEBUG) {
                        Activator.log.debug(0, 10013, null, null, false);
                    }
                    if ((bundleComps = (Vector)this.bundleToServiceComponents.get(keys.nextElement())) == null) continue;
                    i = 0;
                    while (i < bundleComps.size()) {
                        sc = (ServiceComponent)bundleComps.elementAt(i);
                        name = sc.name;
                        if (Activator.DEBUG) {
                            Activator.log.debug(0, 10014, name, null, false);
                        }
                        if (!name.equals(pid) && !name.equals(fpid)) ** GOTO lbl34
                        if (name.equals(fpid) && sc.factory != null) {
                            Activator.log.error("[SCR - SCRManager] ComponentFactory " + name + " cannot be managed using factory configuration!", null);
lbl26:
                            // 3 sources

                            return;
                        }
                        try {
                            if (!sc.enabled) ** GOTO lbl26
                            if (Activator.DEBUG) {
                                Activator.log.debug(0, 10015, pid, null, false);
                            }
                            this.processConfigurationEvent(event, sc);
                            ** continue;
lbl34:
                            // 1 sources

                            ++i;
                            continue;
                        }
                        catch (Throwable e) {
                            Activator.log.error("[SCR] Error while processing configuration event for " + event.getReference().getBundle(), e);
                        }
                        break block17;
                    }
                }
            }
            finally {
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    SCRManager.log.info("[DS perf] Processed configuration event '" + event + "' for " + start + " ms");
                }
            }
        }
    }

    private void processConfigurationEvent(ConfigurationEvent event, ServiceComponent sc) {
        Configuration[] config = null;
        String pid = event.getPid();
        String fpid = event.getFactoryPid();
        switch (event.getType()) {
            case 1: {
                String filter = String.valueOf(fpid != null ? "(&" : "") + "(" + "service.pid" + "=" + pid + ")" + (fpid != null ? "(service.factoryPid=" + fpid + "))" : "");
                try {
                    config = ConfigurationManager.listConfigurations(filter);
                }
                catch (IOException e) {
                    log.error("Error while listing CM Configurations", (Throwable)e);
                }
                catch (InvalidSyntaxException e) {
                    log.error("Error while listing CM Configurations", (Throwable)e);
                }
                if (config == null) {
                    return;
                }
                if (fpid == null) {
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components);
                    sc.enabled = true;
                    this.resolver.enableComponents(components);
                    break;
                }
                ServiceComponentProp scp = sc.getComponentPropByPID(pid);
                if (scp == null && sc.componentProps != null && sc.componentProps.size() == 1 && ((ServiceComponentProp)sc.componentProps.elementAt(0)).getProperties().get("service.pid") == null) {
                    scp = (ServiceComponentProp)sc.componentProps.elementAt(0);
                }
                if (scp != null) {
                    sc.componentProps.removeElement(scp);
                    Vector<ServiceComponentProp> components = new Vector<ServiceComponentProp>();
                    components.addElement(scp);
                    this.resolver.disposeComponentConfigs(components);
                }
                this.resolver.map(sc, config[0]);
                this.resolver.enableComponents(null);
                break;
            }
            case 2: {
                if (fpid == null) {
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components);
                    sc.enabled = true;
                    this.resolver.enableComponents(components);
                    break;
                }
                ServiceComponentProp scp = sc.getComponentPropByPID(pid);
                if (sc.componentProps.size() == 1) {
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components);
                    sc.enabled = true;
                    this.resolver.enableComponents(components);
                    break;
                }
                sc.componentProps.removeElement(scp);
                Vector<ServiceComponentProp> components = new Vector<ServiceComponentProp>();
                components.addElement(scp);
                this.resolver.disposeComponentConfigs(components);
            }
        }
    }

    private void disposeBundles() {
        log.info("disposeBundles()");
        if (this.bundleToServiceComponents != null) {
            Enumeration e = this.bundleToServiceComponents.keys();
            while (e.hasMoreElements()) {
                Bundle bundle = (Bundle)e.nextElement();
                this.stoppingBundle(bundle);
            }
            this.bundleToServiceComponents.clear();
            this.bundleToServiceComponents = null;
        }
    }

    void stoppingBundle(Bundle bundle) {
        Vector components;
        if (this.bundleToServiceComponents != null && (components = (Vector)this.bundleToServiceComponents.remove(bundle)) != null) {
            if (Activator.DEBUG) {
                String bundleName = bundle.getSymbolicName();
                bundleName = bundleName == null || "".equals(bundleName) ? bundle.getLocation() : bundleName;
                log.debug(0, 10016, bundleName, null, false);
            }
            this.resolver.disableComponents(components);
            if (this.bundleToServiceComponents.size() == 0) {
                this.hasRegisteredServiceListener = false;
                this.bc.removeServiceListener((ServiceListener)this);
            }
        }
    }

    synchronized void startedBundle(Bundle bundle) {
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        if (this.bundleToServiceComponents != null && this.bundleToServiceComponents.get(bundle) != null) {
            return;
        }
        Dictionary allHeaders = bundle.getHeaders();
        if (allHeaders.get("Service-Component") == null) {
            return;
        }
        Vector components = this.storage.loadComponentDefinitions(bundle.getBundleId());
        if (components != null && !components.isEmpty()) {
            if (!this.hasRegisteredServiceListener) {
                this.hasRegisteredServiceListener = true;
                this.bc.addServiceListener((ServiceListener)this);
            }
            if (Activator.PERF) {
                start = System.currentTimeMillis() - start;
                log.info("[DS perf] The components for bundle " + bundle + " are parsed for " + start + " ms");
            }
            if (this.bundleToServiceComponents == null) {
                this.bundleToServiceComponents = new Hashtable(11);
            }
            int i = 0;
            while (i < components.size()) {
                block14: {
                    ServiceComponent comp2;
                    ServiceComponent comp = (ServiceComponent)components.elementAt(i);
                    int j = i + 1;
                    while (j < components.size()) {
                        comp2 = (ServiceComponent)components.elementAt(j);
                        if (comp.name.equals(comp2.name)) {
                            Activator.log.error("[SCR] Found components with duplicated names inside their bundle! This component will not be processed: " + comp, null);
                            components.remove(i);
                            --i;
                            break block14;
                        }
                        ++j;
                    }
                    Enumeration keys = this.bundleToServiceComponents.keys();
                    while (keys.hasMoreElements()) {
                        Vector components2 = (Vector)this.bundleToServiceComponents.get(keys.nextElement());
                        int j2 = 0;
                        while (j2 < components2.size()) {
                            comp2 = (ServiceComponent)components2.elementAt(j2);
                            if (comp.name.equals(comp2.name)) {
                                Activator.log.warning("[SCR] Found components with duplicated names! Details: \nComponent1 : " + comp + "\nComponent2: " + comp2, null);
                            }
                            ++j2;
                        }
                    }
                    if (comp.autoenable) {
                        comp.enabled = true;
                    }
                }
                ++i;
            }
            this.bundleToServiceComponents.put(bundle, components);
            this.enqueueWork(this, 1, components, false);
        }
    }

    public void enableComponent(String name, Bundle bundle) {
        this.changeComponent(name, bundle, true);
    }

    private void changeComponent(String name, Bundle bundle, boolean enable) {
        try {
            Vector<ServiceComponent> componentsToProcess = null;
            if (Activator.DEBUG) {
                String message = String.valueOf((enable ? "SCRManager.enableComponent(): " : "SCRManager.disableComponent(): ").concat(name != null ? name : "*all*")) + " from bundle " + bundle.getSymbolicName();
                Activator.log.debug(message, null);
            }
            if (this.bundleToServiceComponents == null) {
                return;
            }
            Vector bundleComponents = (Vector)this.bundleToServiceComponents.get(bundle);
            if (bundleComponents != null) {
                if (name != null) {
                    int i = 0;
                    while (i < bundleComponents.size()) {
                        ServiceComponent component = (ServiceComponent)bundleComponents.elementAt(i);
                        if (component.name.equals(name) && component.enabled != enable) {
                            component.enabled = enable;
                            componentsToProcess = new Vector(2);
                            componentsToProcess.addElement(component);
                            break;
                        }
                        ++i;
                    }
                } else if (enable) {
                    componentsToProcess = new Vector<ServiceComponent>();
                    int i = 0;
                    while (i < bundleComponents.size()) {
                        ServiceComponent sc = (ServiceComponent)bundleComponents.elementAt(i);
                        if (!sc.enabled) {
                            componentsToProcess.addElement(sc);
                            sc.enabled = enable;
                        }
                        ++i;
                    }
                } else {
                    Activator.log.warning("[SCRManager] Cannot dispose all components of a bundle at once!", null);
                }
            }
            if (componentsToProcess != null && !componentsToProcess.isEmpty()) {
                if (enable) {
                    this.enqueueWork(this, 1, componentsToProcess, security);
                } else {
                    this.enqueueWork(this, 2, componentsToProcess, security);
                }
            }
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10018, null, null, false);
            }
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected exception occurred!", e);
        }
    }

    public void disableComponent(String name, Bundle bundle) {
        this.changeComponent(name, bundle, false);
    }

    public void performWork(int workAction, Object workObject) {
        if (workAction == 1) {
            this.resolver.enableComponents((Vector)workObject);
        } else if (workAction == 2) {
            this.resolver.disableComponents((Vector)workObject);
        }
    }

    public class QueuedJob {
        final WorkPerformer performer;
        final int actionType;
        final Object workToDo;

        QueuedJob(WorkPerformer d, int a, Object o) {
            this.performer = d;
            this.actionType = a;
            this.workToDo = o;
        }

        void dispatch() {
            try {
                this.performer.performWork(this.actionType, this.workToDo);
            }
            catch (Throwable t) {
                log.error("[SCR] Error dispatching work ", t);
            }
        }

        public String toString() {
            return "[QueuedJob] WorkPerformer: " + this.performer + "; actionType " + this.actionType;
        }
    }
}

