/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.ignore.IgnoreRule;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.EolCanonicalizingInputStream;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    protected static final Entry[] EOF = new Entry[0];
    static final int BUFFER_SIZE = 2048;
    private static final long MAXIMUM_FILE_SIZE_TO_READ_FULLY = 65536L;
    private final IteratorState state;
    private byte[] contentId;
    private int contentIdFromPtr;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    protected Repository repository;
    private long canonLen = -1L;
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            int cPos;
            byte[] a = o1.encodedName;
            byte[] b = o2.encodedName;
            int aLen = o1.encodedNameLen;
            int bLen = o2.encodedNameLen;
            for (cPos = 0; cPos < aLen && cPos < bLen; ++cPos) {
                int cmp = (a[cPos] & 0xFF) - (b[cPos] & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            if (cPos < aLen) {
                return (a[cPos] & 0xFF) - WorkingTreeIterator.lastPathChar(o2);
            }
            if (cPos < bLen) {
                return WorkingTreeIterator.lastPathChar(o1) - (b[cPos] & 0xFF);
            }
            return WorkingTreeIterator.lastPathChar(o1) - WorkingTreeIterator.lastPathChar(o2);
        }
    };

    protected WorkingTreeIterator(WorkingTreeOptions options) {
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(String prefix, WorkingTreeOptions options) {
        super(prefix);
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.state = p.state;
    }

    protected void initRootIterator(Repository repo) {
        this.repository = repo;
        Entry entry = this.ignoreNode instanceof PerDirectoryIgnoreNode ? ((PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new RootIgnoreNode(entry, repo);
    }

    public void setDirCacheIterator(TreeWalk walk, int treeId) {
        this.state.walk = walk;
        this.state.dirCacheTree = treeId;
    }

    public boolean hasId() {
        if (this.contentIdFromPtr == this.ptr) {
            return true;
        }
        return (this.mode & 0xF000) == 32768;
    }

    public byte[] idBuffer() {
        DirCacheEntry ent;
        DirCacheIterator i;
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        if (this.state.walk != null && (i = this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class)) != null && (ent = i.getDirCacheEntry()) != null && this.compareMetadata(ent) == MetadataDiff.EQUAL) {
            return i.idBuffer();
        }
        switch (this.mode & 0xF000) {
            case 32768: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 40960: {
                return zeroid;
            }
            case 57344: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idSubmodule(this.entries[this.ptr]);
                return this.contentId;
            }
        }
        return zeroid;
    }

    protected byte[] idSubmodule(Entry e) {
        File directory;
        if (this.repository == null) {
            return zeroid;
        }
        try {
            directory = this.repository.getWorkTree();
        }
        catch (NoWorkTreeException nwte) {
            return zeroid;
        }
        return this.idSubmodule(directory, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] idSubmodule(File directory, Entry e) {
        ObjectId head;
        Repository submoduleRepo;
        try {
            submoduleRepo = SubmoduleWalk.getSubmoduleRepository(directory, e.getName());
        }
        catch (IOException exception) {
            return zeroid;
        }
        if (submoduleRepo == null) {
            return zeroid;
        }
        try {
            head = submoduleRepo.resolve("HEAD");
        }
        catch (IOException exception) {
            byte[] byArray = zeroid;
            return byArray;
        }
        finally {
            submoduleRepo.close();
        }
        if (head == null) {
            return zeroid;
        }
        byte[] id = new byte[20];
        head.copyRawTo(id, 0);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] idBufferBlob(Entry e) {
        byte[] byArray;
        InputStream is = e.openInputStream();
        if (is == null) {
            return zeroid;
        }
        try {
            this.state.initializeDigestAndReadBuffer();
            long len = e.getLength();
            InputStream filteredIs = this.possiblyFilteredInputStream(e, is, len);
            byArray = this.computeHash(filteredIs, this.canonLen);
        }
        catch (Throwable throwable) {
            try {
                WorkingTreeIterator.safeClose(is);
                throw throwable;
            }
            catch (IOException err) {
                return zeroid;
            }
        }
        WorkingTreeIterator.safeClose(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream possiblyFilteredInputStream(Entry e, InputStream is, long len) throws IOException {
        if (!this.mightNeedCleaning()) {
            this.canonLen = len;
            return is;
        }
        if (len <= 65536L) {
            int n;
            ByteBuffer rawbuf = IO.readWholeStream(is, (int)len);
            byte[] raw = rawbuf.array();
            if (!this.isBinary(raw, n = rawbuf.limit())) {
                rawbuf = this.filterClean(raw, n);
                raw = rawbuf.array();
                n = rawbuf.limit();
            }
            this.canonLen = n;
            return new ByteArrayInputStream(raw, 0, n);
        }
        if (this.isBinary(e)) {
            this.canonLen = len;
            return is;
        }
        InputStream lenIs = this.filterClean(e.openInputStream());
        try {
            this.canonLen = this.computeLength(lenIs);
        }
        finally {
            WorkingTreeIterator.safeClose(lenIs);
        }
        return this.filterClean(is);
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean mightNeedCleaning() {
        switch (this.getOptions().getAutoCRLF()) {
            default: {
                return false;
            }
            case TRUE: 
            case INPUT: 
        }
        return true;
    }

    private boolean isBinary(byte[] content, int sz) {
        return RawText.isBinary(content, sz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBinary(Entry entry) throws IOException {
        InputStream in = entry.openInputStream();
        try {
            boolean bl = RawText.isBinary(in);
            return bl;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer filterClean(byte[] src, int n) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        try {
            ByteBuffer byteBuffer = IO.readWholeStream(this.filterClean(in), n);
            return byteBuffer;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    private InputStream filterClean(InputStream in) {
        return new EolCanonicalizingInputStream(in, true);
    }

    public WorkingTreeOptions getOptions() {
        return this.state.options;
    }

    public int idOffset() {
        return 0;
    }

    public void reset() {
        if (!this.first()) {
            this.ptr = 0;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    public boolean first() {
        return this.ptr == 0;
    }

    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.canonLen = -1L;
            this.parseEntry();
        }
    }

    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e = this.entries[this.ptr];
        this.mode = e.getMode().getBits();
        int nameLen = e.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryContentLength() throws IOException {
        if (this.canonLen == -1L) {
            long rawLen = this.getEntryLength();
            if (rawLen == 0L) {
                this.canonLen = 0L;
            }
            InputStream is = this.current().openInputStream();
            try {
                this.possiblyFilteredInputStream(this.current(), is, this.current().getLength());
            }
            finally {
                WorkingTreeIterator.safeClose(is);
            }
        }
        return this.canonLen;
    }

    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    public InputStream openEntryStream() throws IOException {
        InputStream rawis = this.current().openInputStream();
        if (this.mightNeedCleaning()) {
            return this.filterClean(rawis);
        }
        return rawis;
    }

    public boolean isEntryIgnored() throws IOException {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int pLen) throws IOException {
        IgnoreNode rules = this.getIgnoreNode();
        if (rules != null) {
            int pOff = this.pathOffset;
            if (0 < pOff) {
                --pOff;
            }
            String p = TreeWalk.pathOf(this.path, pOff, pLen);
            switch (rules.isIgnored(p, FileMode.TREE.equals(this.mode))) {
                case IGNORED: {
                    return true;
                }
                case NOT_IGNORED: {
                    return false;
                }
            }
        }
        if (this.parent instanceof WorkingTreeIterator) {
            return ((WorkingTreeIterator)this.parent).isEntryIgnored(pLen);
        }
        return false;
    }

    private IgnoreNode getIgnoreNode() throws IOException {
        if (this.ignoreNode instanceof PerDirectoryIgnoreNode) {
            this.ignoreNode = ((PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    static int lastPathChar(Entry e) {
        return e.getMode() == FileMode.TREE ? 47 : 0;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        CharsetEncoder nameEncoder = this.state.nameEncoder;
        int o = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            String name;
            Entry e = this.entries[i];
            if (e == null || ".".equals(name = e.getName()) || "..".equals(name) || ".git".equals(name)) continue;
            if (".gitignore".equals(name)) {
                this.ignoreNode = new PerDirectoryIgnoreNode(e);
            }
            if (i != o) {
                this.entries[o] = e;
            }
            e.encodeName(nameEncoder);
            ++o;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModeDifferent(int rawMode) {
        int modeDiff = this.getEntryRawMode() ^ rawMode;
        if (modeDiff == 0) {
            return false;
        }
        if (FileMode.SYMLINK.equals(rawMode)) {
            return false;
        }
        if (!this.state.options.isFileMode()) {
            modeDiff &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        return modeDiff != 0;
    }

    public MetadataDiff compareMetadata(DirCacheEntry entry) {
        if (entry.isAssumeValid()) {
            return MetadataDiff.EQUAL;
        }
        if (entry.isUpdateNeeded()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (!entry.isSmudged() && entry.getLength() != (int)this.getEntryLength()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (this.isModeDifferent(entry.getRawMode())) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        long cacheLastModified = entry.getLastModified();
        long fileLastModified = this.getEntryLastModified();
        if (cacheLastModified % 1000L == 0L) {
            fileLastModified -= fileLastModified % 1000L;
        }
        if (fileLastModified != cacheLastModified) {
            return MetadataDiff.DIFFER_BY_TIMESTAMP;
        }
        if (!entry.isSmudged()) {
            return MetadataDiff.EQUAL;
        }
        return MetadataDiff.SMUDGED;
    }

    public boolean isModified(DirCacheEntry entry, boolean forceContentCheck) {
        MetadataDiff diff = this.compareMetadata(entry);
        switch (diff) {
            case DIFFER_BY_TIMESTAMP: {
                if (forceContentCheck) {
                    return this.contentCheck(entry);
                }
                return true;
            }
            case SMUDGED: {
                return this.contentCheck(entry);
            }
            case EQUAL: {
                return false;
            }
            case DIFFER_BY_METADATA: {
                return true;
            }
        }
        throw new IllegalStateException(MessageFormat.format(JGitText.get().unexpectedCompareResult, diff.name()));
    }

    public FileMode getIndexFileMode(DirCacheIterator indexIter) {
        FileMode wtMode = this.getEntryFileMode();
        if (indexIter == null) {
            return wtMode;
        }
        if (this.getOptions().isFileMode()) {
            return wtMode;
        }
        FileMode iMode = indexIter.getEntryFileMode();
        if (FileMode.REGULAR_FILE == wtMode && FileMode.EXECUTABLE_FILE == iMode) {
            return iMode;
        }
        if (FileMode.EXECUTABLE_FILE == wtMode && FileMode.REGULAR_FILE == iMode) {
            return iMode;
        }
        return wtMode;
    }

    private boolean contentCheck(DirCacheEntry entry) {
        if (this.getEntryObjectId().equals(entry.getObjectId())) {
            entry.setLength((int)this.getEntryLength());
            return false;
        }
        return true;
    }

    private long computeLength(InputStream in) throws IOException {
        long n;
        long length = 0L;
        while ((n = in.skip(0x100000L)) > 0L) {
            length += n;
        }
        return length;
    }

    private byte[] computeHash(InputStream in, long length) throws IOException {
        int r;
        MessageDigest contentDigest = this.state.contentDigest;
        byte[] contentReadBuffer = this.state.contentReadBuffer;
        contentDigest.reset();
        contentDigest.update(hblob);
        contentDigest.update((byte)32);
        long sz = length;
        if (sz == 0L) {
            contentDigest.update((byte)48);
        } else {
            int bufn;
            int p = bufn = contentReadBuffer.length;
            do {
                contentReadBuffer[--p] = digits[(int)(sz % 10L)];
            } while ((sz /= 10L) > 0L);
            contentDigest.update(contentReadBuffer, p, bufn - p);
        }
        contentDigest.update((byte)0);
        while ((r = in.read(contentReadBuffer)) > 0) {
            contentDigest.update(contentReadBuffer, 0, r);
            sz += (long)r;
        }
        if (sz != length) {
            return zeroid;
        }
        return contentDigest.digest();
    }

    private static final class IteratorState {
        final WorkingTreeOptions options;
        final CharsetEncoder nameEncoder;
        MessageDigest contentDigest;
        byte[] contentReadBuffer;
        TreeWalk walk;
        int dirCacheTree;

        IteratorState(WorkingTreeOptions options) {
            this.options = options;
            this.nameEncoder = Constants.CHARSET.newEncoder();
        }

        void initializeDigestAndReadBuffer() {
            if (this.contentDigest == null) {
                this.contentDigest = Constants.newMessageDigest();
                this.contentReadBuffer = new byte[2048];
            }
        }
    }

    private static class RootIgnoreNode
    extends PerDirectoryIgnoreNode {
        final Repository repository;

        RootIgnoreNode(Entry entry, Repository repository) {
            super(entry);
            this.repository = repository;
        }

        IgnoreNode load() throws IOException {
            IgnoreNode r;
            if (this.entry != null) {
                r = super.load();
                if (r == null) {
                    r = new IgnoreNode();
                }
            } else {
                r = new IgnoreNode();
            }
            FS fs = this.repository.getFS();
            String path = this.repository.getConfig().get(CoreConfig.KEY).getExcludesFile();
            if (path != null) {
                File excludesfile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
                this.loadRulesFromFile(r, excludesfile);
            }
            File exclude = fs.resolve(this.repository.getDirectory(), "info/exclude");
            this.loadRulesFromFile(r, exclude);
            return r.getRules().isEmpty() ? null : r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadRulesFromFile(IgnoreNode r, File exclude) throws FileNotFoundException, IOException {
            if (exclude.exists()) {
                FileInputStream in = new FileInputStream(exclude);
                try {
                    r.parse(in);
                }
                finally {
                    in.close();
                }
            }
        }
    }

    private static class PerDirectoryIgnoreNode
    extends IgnoreNode {
        final Entry entry;

        PerDirectoryIgnoreNode(Entry entry) {
            super(Collections.<IgnoreRule>emptyList());
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IgnoreNode load() throws IOException {
            IgnoreNode r = new IgnoreNode();
            InputStream in = this.entry.openInputStream();
            try {
                r.parse(in);
            }
            finally {
                in.close();
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    protected static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        protected Entry() {
        }

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b;
            try {
                b = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()));
            }
            this.encodedNameLen = b.limit();
            if (b.hasArray() && b.arrayOffset() == 0) {
                this.encodedName = b.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b.get(this.encodedName);
            }
        }

        public String toString() {
            return this.getMode().toString() + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        public abstract long getLastModified();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataDiff {
        EQUAL,
        DIFFER_BY_METADATA,
        SMUDGED,
        DIFFER_BY_TIMESTAMP;

    }
}

