/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefAdvertiser;

public class ReceivePack
extends BaseReceivePack {
    private PreReceiveHook preReceive = PreReceiveHook.NULL;
    private PostReceiveHook postReceive = PostReceiveHook.NULL;

    public ReceivePack(Repository into) {
        super(into);
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h) {
        this.preReceive = h != null ? h : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h) {
        this.postReceive = h != null ? h : PostReceiveHook.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        this.init(input, output, messages);
        try {
            this.service();
        }
        finally {
            try {
                this.close();
            }
            finally {
                this.release();
            }
        }
    }

    private void service() throws IOException {
        if (this.biDirectionalPipe) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
            this.pckOut.flush();
        } else {
            this.getAdvertisedOrDefaultRefs();
        }
        if (this.hasError()) {
            return;
        }
        this.recvCommands();
        if (this.hasCommands()) {
            this.enableCapabilities();
            Throwable unpackError = null;
            if (this.needPack()) {
                try {
                    this.receivePackAndCheckConnectivity();
                }
                catch (IOException err) {
                    unpackError = err;
                }
                catch (RuntimeException err) {
                    unpackError = err;
                }
                catch (Error err) {
                    unpackError = err;
                }
            }
            if (unpackError == null) {
                this.validateCommands();
                this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
                this.executeCommands();
            }
            this.unlockPack();
            if (this.reportStatus) {
                this.sendStatusReport(true, unpackError, new BaseReceivePack.Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.pckOut.writeString(s + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgOut != null) {
                this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.msgOut.write(Constants.encode(s + "\n"));
                    }
                });
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
            if (unpackError != null) {
                throw new UnpackException(unpackError);
            }
        }
    }

    protected String getLockMessageProcessName() {
        return "jgit receive-pack";
    }
}

