/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.symboltable.TypeSet;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;

public class TypeSetTest {
    private static final /* synthetic */ Class class$java$util$Set;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$PMD;
    private static final /* synthetic */ Class class$java$io$File;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$TypeSetTest;

    @Test
    public void testASTCompilationUnitPackage() {
        TypeSet t = new TypeSet();
        t.setASTCompilationUnitPackage("java.lang.");
        Assert.assertEquals((Object)"java.lang.", (Object)t.getASTCompilationUnitPackage());
    }

    @Test
    public void testAddImport() {
        TypeSet t = new TypeSet();
        t.addImport("java.io.File");
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)t.getImportsCount()));
    }

    @Test
    public void testFindClassImplicitImport() throws Throwable {
        TypeSet t = new TypeSet();
        Class clazz = t.findClass("String");
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)clazz);
    }

    @Test
    public void testFindClassSamePackage() throws Throwable {
        TypeSet t = new TypeSet();
        t.setASTCompilationUnitPackage("net.sourceforge.pmd.");
        Class clazz = t.findClass("PMD");
        Class<?> clazz2 = class$net$sourceforge$pmd$PMD;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$PMD = new PMD[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)clazz);
    }

    @Test
    public void testFindClassExplicitImport() throws Throwable {
        TypeSet t = new TypeSet();
        t.addImport("java.io.File");
        Class clazz = t.findClass("File");
        Class<?> clazz2 = class$java$io$File;
        if (clazz2 == null) {
            clazz2 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)clazz);
    }

    @Test
    public void testFindClassImportOnDemand() throws Throwable {
        TypeSet t = new TypeSet();
        t.addImport("java.io.*");
        Class clazz = t.findClass("File");
        Class<?> clazz2 = class$java$io$File;
        if (clazz2 == null) {
            clazz2 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)clazz);
    }

    @Test
    public void testFindClassPrimitive() throws Throwable {
        TypeSet t = new TypeSet();
        Assert.assertEquals(Integer.TYPE, (Object)t.findClass("int"));
    }

    @Test
    public void testFindClassVoid() throws Throwable {
        TypeSet t = new TypeSet();
        Assert.assertEquals(Void.TYPE, (Object)t.findClass("void"));
    }

    @Test
    public void testFindFullyQualified() throws Throwable {
        TypeSet t = new TypeSet();
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, (Object)t.findClass("java.lang.String"));
        Class<?> clazz2 = class$java$util$Set;
        if (clazz2 == null) {
            clazz2 = class$java$util$Set = new Set[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)t.findClass("java.util.Set"));
    }

    @Test
    public void testPrimitiveTypeResolver() throws Throwable {
        TypeSet.PrimitiveTypeResolver r = new TypeSet.PrimitiveTypeResolver();
        Assert.assertEquals(Integer.TYPE, (Object)r.resolve("int"));
        Assert.assertEquals(Byte.TYPE, (Object)r.resolve("byte"));
        Assert.assertEquals(Long.TYPE, (Object)r.resolve("long"));
    }

    @Test
    public void testVoidTypeResolver() throws Throwable {
        TypeSet.VoidResolver r = new TypeSet.VoidResolver();
        Assert.assertEquals(Void.TYPE, (Object)r.resolve("void"));
    }

    @Test
    public void testExplicitImportResolver() throws Throwable {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.io.File");
        TypeSet.ExplicitImportResolver r = new TypeSet.ExplicitImportResolver(imports);
        Class<?> clazz = class$java$io$File;
        if (clazz == null) {
            clazz = class$java$io$File = new File[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, (Object)r.resolve("File"));
    }

    @Test
    public void testImplicitImportResolverPass() throws Throwable {
        TypeSet.ImplicitImportResolver r = new TypeSet.ImplicitImportResolver();
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, (Object)r.resolve("String"));
    }

    @Test(expected=ClassNotFoundException.class)
    public void testImplicitImportResolverPassFail() throws Throwable {
        TypeSet.ImplicitImportResolver r = new TypeSet.ImplicitImportResolver();
        r.resolve("PMD");
    }

    @Test
    public void testCurrentPackageResolverPass() throws Throwable {
        TypeSet.CurrentPackageResolver r = new TypeSet.CurrentPackageResolver("net.sourceforge.pmd.");
        Class<?> clazz = class$net$sourceforge$pmd$PMD;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$PMD = new PMD[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, (Object)r.resolve("PMD"));
    }

    @Test
    public void testImportOnDemandResolverPass() throws Throwable {
        TypeSet.Resolver r = this.getResolver();
        Class<?> clazz = class$java$util$Set;
        if (clazz == null) {
            clazz = class$java$util$Set = new Set[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, (Object)r.resolve("Set"));
        Class<?> clazz2 = class$java$io$File;
        if (clazz2 == null) {
            clazz2 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz2, (Object)r.resolve("File"));
    }

    @Test(expected=ClassNotFoundException.class)
    public void importOnDemandResolverFail1() throws Throwable {
        TypeSet.Resolver r = this.getResolver();
        r.resolve("foo");
    }

    @Test(expected=ClassNotFoundException.class)
    public void importOnDemandResolverFail2() throws Throwable {
        TypeSet.Resolver r = this.getResolver();
        r.resolve("String");
    }

    private TypeSet.Resolver getResolver() {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.io.*");
        imports.add("java.util.*");
        TypeSet.ImportOnDemandResolver r = new TypeSet.ImportOnDemandResolver(imports);
        return r;
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$TypeSetTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$TypeSetTest = new TypeSetTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

