/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.Iterator;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import org.junit.Assert;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class SourceFileScopeTest
extends STBBaseTst {
    private static final String TEST1 = "public class Foo {}" + PMD.EOL;
    private static final String TEST2 = "package foo.bar;" + PMD.EOL + "public class Foo {" + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST3 = "public class Foo {" + PMD.EOL + " public class Bar {" + PMD.EOL + " }" + PMD.EOL + "}" + PMD.EOL;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$SourceFileScopeTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTCompilationUnit;

    @org.junit.Test
    public void testClassDeclAppears() {
        this.parseCode(TEST1);
        Map m = this.acu.getScope().getClassDeclarations();
        ClassNameDeclaration classNameDeclaration = (ClassNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)classNameDeclaration.getImage(), (Object)"Foo");
    }

    @org.junit.Test
    public void testPackageIsEmptyString() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit = new ASTCompilationUnit[0].getClass().getComponentType();
        }
        ASTCompilationUnit decl = (ASTCompilationUnit)this.acu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)decl.getScope().getEnclosingSourceFileScope().getPackageName(), (Object)"");
    }

    @org.junit.Test
    public void testPackageNameFound() {
        this.parseCode(TEST2);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit = new ASTCompilationUnit[0].getClass().getComponentType();
        }
        ASTCompilationUnit decl = (ASTCompilationUnit)this.acu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)decl.getScope().getEnclosingSourceFileScope().getPackageName(), (Object)"foo.bar");
    }

    @org.junit.Test
    public void testNestedClasses() {
        this.parseCode(TEST3);
        Map m = this.acu.getScope().getClassDeclarations();
        Iterator iterator = m.keySet().iterator();
        ClassNameDeclaration classNameDeclaration = (ClassNameDeclaration)iterator.next();
        Assert.assertEquals((Object)classNameDeclaration.getImage(), (Object)"Foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$SourceFileScopeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$SourceFileScopeTest = new SourceFileScopeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

