/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.symboltable.NameFinder;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import org.junit.Assert;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class NameOccurrencesTest
extends STBBaseTst {
    public static final String TEST1 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  super.x = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST2 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  this.x = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST3 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  x = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST4 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  b.x = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST5 = "public class Foo{" + PMD.EOL + "    private int counter;" + PMD.EOL + "    private Foo(){" + PMD.EOL + "        counter = 0;" + PMD.EOL + "    }" + PMD.EOL + "    private int foo(){" + PMD.EOL + "        if (++counter < 3) {" + PMD.EOL + "            return 0;" + PMD.EOL + "        }" + PMD.EOL + "        return 1;" + PMD.EOL + "    }" + PMD.EOL + "}";
    public static final String TEST6 = "public class Foo{" + PMD.EOL + "    private int counter;" + PMD.EOL + "    private Foo(){" + PMD.EOL + "        counter = 0;" + PMD.EOL + "    }" + PMD.EOL + "    private int foo(){" + PMD.EOL + "        if (++this.counter < 3) {" + PMD.EOL + "            return 0;" + PMD.EOL + "        }" + PMD.EOL + "        return 1;" + PMD.EOL + "    }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$NameOccurrencesTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;

    @org.junit.Test
    public void testSuper() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(0));
        Assert.assertEquals((Object)"super", (Object)((NameOccurrence)occs.getNames().get(0)).getImage());
    }

    @org.junit.Test
    public void testThis() {
        this.parseCode(TEST2);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(0));
        Assert.assertEquals((Object)"this", (Object)((NameOccurrence)occs.getNames().get(0)).getImage());
        Assert.assertEquals((Object)"x", (Object)((NameOccurrence)occs.getNames().get(1)).getImage());
    }

    @org.junit.Test
    public void testNameLinkage() {
        this.parseCode(TEST2);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(0));
        NameOccurrence thisNameOccurrence = (NameOccurrence)occs.getNames().get(0);
        Assert.assertEquals((Object)thisNameOccurrence.getNameForWhichThisIsAQualifier(), occs.getNames().get(1));
    }

    @org.junit.Test
    public void testSimpleVariableOccurrence() {
        this.parseCode(TEST3);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(0));
        Assert.assertEquals((Object)"x", (Object)((NameOccurrence)occs.getNames().get(0)).getImage());
        Assert.assertFalse((boolean)((NameOccurrence)occs.getNames().get(0)).isThisOrSuper());
        Assert.assertFalse((boolean)((NameOccurrence)occs.getNames().get(0)).isMethodOrConstructorInvocation());
        Assert.assertTrue((boolean)((NameOccurrence)occs.getNames().get(0)).isOnLeftHandSide());
    }

    @org.junit.Test
    public void testQualifiedOccurrence() {
        this.parseCode(TEST4);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(0));
        Assert.assertEquals((Object)"b", (Object)((NameOccurrence)occs.getNames().get(0)).getImage());
        Assert.assertEquals((Object)"x", (Object)((NameOccurrence)occs.getNames().get(1)).getImage());
    }

    @org.junit.Test
    public void testIsSelfAssignment() {
        this.parseCode(TEST5);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        NameFinder occs = new NameFinder((ASTPrimaryExpression)nodes.get(2));
        Assert.assertTrue((boolean)((NameOccurrence)occs.getNames().get(0)).isSelfAssignment());
        this.parseCode(TEST6);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        nodes = this.acu.findChildrenOfType((Class)clazz2);
        occs = new NameFinder((ASTPrimaryExpression)nodes.get(2));
        Assert.assertTrue((boolean)((NameOccurrence)occs.getNames().get(0)).isSelfAssignment());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$NameOccurrencesTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$NameOccurrencesTest = new NameOccurrencesTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

