/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class ClassScopeTest
extends STBBaseTst {
    private static final String METHOD_USAGE_SEEN2 = "public class Foo {" + PMD.EOL + " public void baz() {" + PMD.EOL + "  baz(x, y);" + PMD.EOL + " }" + PMD.EOL + " private void baz(int x, int y) {}" + PMD.EOL + "}";
    private static final String METHOD_USAGE_SEEN = "public class Foo {" + PMD.EOL + " private void bar() {}" + PMD.EOL + " public void buz() {" + PMD.EOL + "  bar();" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String METHOD_USAGE_SEEN_WITH_THIS = "public class Foo {" + PMD.EOL + " private void bar() {}" + PMD.EOL + " public void buz() {" + PMD.EOL + "  this.bar();" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String METH = "public class Test {" + PMD.EOL + "  static { " + PMD.EOL + "   int y; " + PMD.EOL + "  } " + PMD.EOL + "  void bar(int x) {} " + PMD.EOL + "  void baz(int x) {} " + PMD.EOL + "}";
    private static final String NESTED_CLASS_FOUND = "public class Test {" + PMD.EOL + "  private class Buz {} " + PMD.EOL + "}";
    private static final String ONE_PARAM = "public class Test {" + PMD.EOL + "  void bar(String x) {" + PMD.EOL + "  }" + PMD.EOL + "}";
    private static final String TWO_PARAMS = "public class Test {" + PMD.EOL + "  void bar(String x, int y) {" + PMD.EOL + "  }" + PMD.EOL + "}";
    private static final String NO_PARAMS = "public class Test {" + PMD.EOL + "  void bar() {" + PMD.EOL + "  }" + PMD.EOL + "}";
    private static final String CLASS_NAME = "public class Foo {}";
    private static final String METHOD_DECLARATIONS_RECORDED = "public class Foo {" + PMD.EOL + " private void bar() {}" + PMD.EOL + "}";
    private static final String METHODS_WITH_DIFF_ARG = "public class Foo {" + PMD.EOL + " private void bar(String x) {}" + PMD.EOL + " private void bar() {}" + PMD.EOL + "}";
    private static final String ENUM_SCOPE = "public enum Foo {" + PMD.EOL + " HEAP(\"foo\");" + PMD.EOL + " private final String fuz;" + PMD.EOL + " public String getFuz() {" + PMD.EOL + "  return fuz;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$ClassScopeTest;

    @Test
    public void testEnumsClassScope() {
        this.parseCode15(ENUM_SCOPE);
    }

    @Test
    public void testAnonymousInnerClassName() {
        ClassScope s = new ClassScope();
        Assert.assertEquals((Object)"Anonymous$1", (Object)s.getClassName());
        s = new ClassScope();
        Assert.assertEquals((Object)"Anonymous$2", (Object)s.getClassName());
    }

    @Test
    public void testContains() {
        ClassScope s = new ClassScope("Foo");
        ASTVariableDeclaratorId node = new ASTVariableDeclaratorId(1);
        node.setImage("bar");
        s.addDeclaration(new VariableNameDeclaration(node));
        Assert.assertTrue((boolean)s.getVariableDeclarations().keySet().iterator().hasNext());
    }

    @Test
    public void testCantContainsSuperToString() {
        ClassScope s = new ClassScope("Foo");
        SimpleJavaNode node = new SimpleJavaNode(1);
        node.setImage("super.toString");
        Assert.assertFalse((boolean)s.contains(new NameOccurrence((SimpleNode)node, node.getImage())));
    }

    @Test
    public void testContainsStaticVariablePrefixedWithClassName() {
        ClassScope s = new ClassScope("Foo");
        ASTVariableDeclaratorId node = new ASTVariableDeclaratorId(1);
        node.setImage("X");
        s.addDeclaration(new VariableNameDeclaration(node));
        SimpleJavaNode node2 = new SimpleJavaNode(2);
        node2.setImage("Foo.X");
        Assert.assertTrue((boolean)s.contains(new NameOccurrence((SimpleNode)node2, node2.getImage())));
    }

    @Test
    public void testClassName() {
        this.parseCode(CLASS_NAME);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)"Foo", (Object)n.getScope().getEnclosingClassScope().getClassName());
    }

    @Test
    public void testMethodDeclarationRecorded() {
        this.parseCode(METHOD_DECLARATIONS_RECORDED);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        ClassScope s = (ClassScope)n.getScope();
        Map m = s.getMethodDeclarations();
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)m.size()));
        MethodNameDeclaration mnd = (MethodNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"bar", (Object)mnd.getImage());
        ASTMethodDeclaration node = (ASTMethodDeclaration)mnd.getNode().jjtGetParent();
        Assert.assertTrue((boolean)node.isPrivate());
    }

    @Test
    public void testTwoMethodsSameNameDiffArgs() {
        this.parseCode(METHODS_WITH_DIFF_ARG);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)m.size()));
        Iterator i = m.keySet().iterator();
        MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
        Assert.assertEquals((Object)"bar", (Object)mnd.getImage());
        Assert.assertEquals((Object)"bar", (Object)((MethodNameDeclaration)i.next()).getImage());
    }

    @Test
    public final void testOneParams() throws Throwable {
        this.parseCode(ONE_PARAM);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        MethodNameDeclaration mnd = (MethodNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"(String)", (Object)mnd.getParameterDisplaySignature());
    }

    @Test
    public final void testTwoParams() throws Throwable {
        this.parseCode(TWO_PARAMS);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        MethodNameDeclaration mnd = (MethodNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"(String,int)", (Object)mnd.getParameterDisplaySignature());
    }

    @Test
    public final void testNoParams() throws Throwable {
        this.parseCode(NO_PARAMS);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        MethodNameDeclaration mnd = (MethodNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"()", (Object)mnd.getParameterDisplaySignature());
    }

    @Test
    public final void testNestedClassDeclFound() throws Throwable {
        this.parseCode(NESTED_CLASS_FOUND);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        ClassScope c = (ClassScope)n.getScope();
        Map m = c.getClassDeclarations();
        ClassNameDeclaration cnd = (ClassNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"Buz", (Object)cnd.getImage());
    }

    @Test
    public final void testbuz() throws Throwable {
        this.parseCode(METH);
    }

    @Test
    public void testMethodUsageSeen() {
        Map.Entry entry;
        MethodNameDeclaration mnd;
        this.parseCode(METHOD_USAGE_SEEN);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        Iterator i = m.entrySet().iterator();
        while (!(mnd = (MethodNameDeclaration)(entry = i.next()).getKey()).getImage().equals("bar")) {
        }
        List usages = (List)entry.getValue();
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)usages.size()));
        Assert.assertEquals((Object)"bar", (Object)((NameOccurrence)usages.get(0)).getImage());
    }

    @Test
    public void testMethodUsageSeenWithThis() {
        Map.Entry entry;
        MethodNameDeclaration mnd;
        this.parseCode(METHOD_USAGE_SEEN_WITH_THIS);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Map m = ((ClassScope)n.getScope()).getMethodDeclarations();
        Iterator i = m.entrySet().iterator();
        while (!(mnd = (MethodNameDeclaration)(entry = i.next()).getKey()).getImage().equals("bar")) {
        }
        List usages = (List)entry.getValue();
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)usages.size()));
        Assert.assertEquals((Object)"bar", (Object)((NameOccurrence)usages.get(0)).getImage());
    }

    @Test
    public void testMethodUsageSeen2() {
        ASTClassOrInterfaceDeclaration n;
        Map m;
        Iterator i;
        Map.Entry entry;
        MethodNameDeclaration mnd;
        this.parseCode(METHOD_USAGE_SEEN2);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        if ((mnd = (MethodNameDeclaration)(entry = (i = (m = ((ClassScope)(n = (ASTClassOrInterfaceDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope()).getMethodDeclarations()).entrySet().iterator()).next()).getKey()).getNode().getBeginLine() == 2) {
            List usages = (List)entry.getValue();
            System.out.println(usages.size());
            System.out.println(mnd);
            mnd = (MethodNameDeclaration)i.next();
        }
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$ClassScopeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$ClassScopeTest = new ClassScopeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

