/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Ignore;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class AcceptanceTest
extends STBBaseTst {
    private static final String TEST_DEMO = "public class Foo  {" + PMD.EOL + " void bar(ArrayList buz) { " + PMD.EOL + " } " + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST_EQ = "public class Foo  {" + PMD.EOL + " boolean foo(String a, String b) { " + PMD.EOL + "  return a == b; " + PMD.EOL + " } " + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST1 = "import java.io.*;" + PMD.EOL + "public class Foo  {" + PMD.EOL + " void buz( ) {" + PMD.EOL + "  Object o = new Serializable() { int x; };" + PMD.EOL + "  Object o1 = new Serializable() { int x; };" + PMD.EOL + " }" + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST_INITIALIZERS = "public class Foo  {" + PMD.EOL + " {} " + PMD.EOL + " static {} " + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST_CATCH_BLOCKS = "public class Foo  {" + PMD.EOL + " void foo() { " + PMD.EOL + "  try { " + PMD.EOL + "  } catch (Exception e) { " + PMD.EOL + "   e.printStackTrace(); " + PMD.EOL + "  } " + PMD.EOL + " } " + PMD.EOL + "}" + PMD.EOL;
    private static final String TEST_FIELD = "public class MyClass {" + PMD.EOL + " private int a; " + PMD.EOL + " boolean b = MyClass.ASCENDING; " + PMD.EOL + "}" + PMD.EOL;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$AcceptanceTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTInitializer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTCatchStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTEqualityExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlock;

    @Ignore
    @org.junit.Test
    public void testClashingSymbols() {
        this.parseCode(TEST1);
    }

    @Ignore
    @org.junit.Test
    public void testInitializer() {
        this.parseCode(TEST_INITIALIZERS);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTInitializer;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTInitializer = new ASTInitializer[0].getClass().getComponentType();
        }
        ASTInitializer a = (ASTInitializer)this.acu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertFalse((boolean)a.isStatic());
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTInitializer;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTInitializer = new ASTInitializer[0].getClass().getComponentType();
        }
        a = (ASTInitializer)this.acu.findChildrenOfType((Class)clazz2).get(1);
        Assert.assertTrue((boolean)a.isStatic());
    }

    @Ignore
    @org.junit.Test
    public void testCatchBlocks() {
        this.parseCode(TEST_CATCH_BLOCKS);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTCatchStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTCatchStatement = new ASTCatchStatement[0].getClass().getComponentType();
        }
        ASTCatchStatement c = (ASTCatchStatement)this.acu.findChildrenOfType((Class)clazz).get(0);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTBlock;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTBlock = new ASTBlock[0].getClass().getComponentType();
        }
        ASTBlock a = (ASTBlock)c.findChildrenOfType((Class)clazz2).get(0);
        Scope s = a.getScope();
        Map vars = s.getParent().getVariableDeclarations();
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)vars.size()));
        VariableNameDeclaration v = (VariableNameDeclaration)vars.keySet().iterator().next();
        Assert.assertEquals((Object)"e", (Object)v.getImage());
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)((List)vars.get(v)).size()));
    }

    @Ignore
    @org.junit.Test
    public void testEq() {
        this.parseCode(TEST_EQ);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTEqualityExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTEqualityExpression = new ASTEqualityExpression[0].getClass().getComponentType();
        }
        ASTEqualityExpression e = (ASTEqualityExpression)this.acu.findChildrenOfType((Class)clazz).get(0);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        ASTMethodDeclaration method = (ASTMethodDeclaration)e.getFirstParentOfType((Class)clazz2);
        Scope s = method.getScope();
        Map m = s.getVariableDeclarations();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            VariableNameDeclaration vnd = (VariableNameDeclaration)i.next();
            SimpleNode node = vnd.getNode();
        }
    }

    @org.junit.Test
    public void testFieldFinder() {
    }

    @Ignore
    @org.junit.Test
    public void testDemo() {
        this.parseCode(TEST_DEMO);
        System.out.println(TEST_DEMO);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        ASTMethodDeclaration node = (ASTMethodDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        Scope s = node.getScope();
        Map m = s.getVariableDeclarations();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            VariableNameDeclaration d = (VariableNameDeclaration)i.next();
            System.out.println("Variable: " + d.getImage());
            System.out.println("Type: " + d.getTypeImage());
        }
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$AcceptanceTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$AcceptanceTest = new AcceptanceTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

