/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.rules.XPathRule;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Before;
import test.net.sourceforge.pmd.testframework.RuleTst;

public class XPathRuleTest
extends RuleTst {
    XPathRule rule;
    private static final String TEST1 = "public class Foo {" + PMD.EOL + " int a;" + PMD.EOL + "}";
    private static final String TEST2 = "public class Foo {" + PMD.EOL + " int faddle;" + PMD.EOL + " int fiddle;" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$rules$XPathRuleTest;

    @Before
    public void setUp() {
        this.rule = new XPathRule();
        this.rule.setMessage("XPath Rule Failed");
    }

    @org.junit.Test
    public void testPluginname() throws Throwable {
        XPathRule rule = new XPathRule();
        rule.addProperty("xpath", "//VariableDeclaratorId[string-length(@Image) < 3]");
        rule.setMessage("{0}");
        rule.addProperty("pluginname", "true");
        PMD p = new PMD();
        RuleContext ctx = new RuleContext();
        Report report = new Report();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule((Rule)rule);
        p.processFile((Reader)new StringReader(TEST1), rules, ctx);
        RuleViolation rv = (RuleViolation)report.iterator().next();
        Assert.assertEquals((Object)"a", (Object)rv.getDescription());
    }

    @org.junit.Test
    public void testVariables() throws Throwable {
        XPathRule rule = new XPathRule();
        rule.addProperty("xpath", "//VariableDeclaratorId[@Image=$var]");
        rule.setMessage("Avoid vars");
        rule.addProperty("var", "fiddle");
        PMD p = new PMD();
        RuleContext ctx = new RuleContext();
        Report report = new Report();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule((Rule)rule);
        p.processFile((Reader)new StringReader(TEST2), rules, ctx);
        RuleViolation rv = (RuleViolation)report.iterator().next();
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)rv.getBeginLine()));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$rules$XPathRuleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$rules$XPathRuleTest = new XPathRuleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

