/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import test.net.sourceforge.pmd.testframework.RuleTst;

public class XMLRendererTest
extends RuleTst {
    private static final String TEST1 = "public class Foo {}" + PMD.EOL;
    private static final String TEST2 = "public class Foo {" + PMD.EOL + " public class Foo {}" + PMD.EOL + "}" + PMD.EOL;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$renderers$XMLRendererTest;

    @Test
    public void testEmptyReport() throws Throwable {
        Element root = this.parseRootElement(new Report());
        Assert.assertEquals((Object)"pmd", (Object)root.getNodeName());
        Assert.assertNull((Object)root.getFirstChild().getNextSibling());
    }

    @Test
    public void testErrorReport() throws Throwable {
        Report report = new Report();
        report.addError(new Report.ProcessingError("test_msg", "test_filename"));
        Element root = this.parseRootElement(report);
        Assert.assertEquals((Object)"test_msg", (Object)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("msg").getNodeValue());
    }

    @Test
    public void testSingleReport() throws Throwable {
        Report report = new Report();
        this.runTestFromString(TEST1, (Rule)new FooRule(), report);
        Element root = this.parseRootElement(report);
        Assert.assertEquals((Object)"n/a", (Object)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"Foo", (Object)root.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getAttributes().getNamedItem("rule").getNodeValue());
        Assert.assertEquals((Object)"RuleSet", (Object)root.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getAttributes().getNamedItem("ruleset").getNodeValue());
        Assert.assertEquals((Object)"1", (Object)root.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getAttributes().getNamedItem("beginline").getNodeValue());
    }

    @Test
    public void testDoubleReport() throws Throwable {
        Report report = new Report();
        this.runTestFromString(TEST2, (Rule)new FooRule(), report);
        this.runTestFromString(TEST2, (Rule)new FooRule(), report);
        Element root = this.parseRootElement(report);
        Assert.assertEquals((Object)"Foo", (Object)root.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getAttributes().getNamedItem("rule").getNodeValue());
        Assert.assertEquals((Object)"Foo", (Object)root.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getNextSibling().getNextSibling().getAttributes().getNamedItem("rule").getNodeValue());
    }

    @Test
    public void testTwoFiles() throws Throwable {
        Report report = new Report();
        FooRule rule = new FooRule();
        this.runTestFromString(TEST2, (Rule)rule, report);
        PMD p = new PMD();
        p.setJavaVersion(SourceType.JAVA_14);
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("bar");
        RuleSet rules = new RuleSet();
        rules.addRule((Rule)rule);
        p.processFile((Reader)new StringReader(TEST2), rules, ctx);
        Element root = this.parseRootElement(report);
        Assert.assertEquals((Object)"bar", (Object)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals((Object)"n/a", (Object)root.getFirstChild().getNextSibling().getNextSibling().getNextSibling().getAttributes().getNamedItem("name").getNodeValue());
    }

    private Element parseRootElement(Report rpt) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(new XMLRenderer().render(rpt)))).getDocumentElement();
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$renderers$XMLRendererTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$renderers$XMLRendererTest = new XMLRendererTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    private static class FooRule
    extends AbstractRule {
        private FooRule() {
        }

        public Object visit(ASTClassOrInterfaceDeclaration c, Object ctx) {
            if (c.getImage().equals("Foo")) {
                this.addViolation(ctx, (SimpleNode)c);
            }
            return ctx;
        }

        public String getMessage() {
            return "blah";
        }

        public String getName() {
            return "Foo";
        }

        public String getRuleSetName() {
            return "RuleSet";
        }

        public String getDescription() {
            return "desc";
        }
    }
}

