/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.properties;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.cpd.ReportException;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import test.net.sourceforge.pmd.properties.NonRuleWithAllPropertyTypes;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;

public class PropertyAccessorTest
extends SimpleAggregatorTst {
    private AbstractRule rule;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$properties$PropertyAccessorTest;

    @Before
    public void setUp() {
        this.rule = new NonRuleWithAllPropertyTypes();
    }

    public static boolean areEqual(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(boolean[] a, boolean[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @org.junit.Test
    public void testIntegers() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.singleInt, (Object)new Integer(0));
        Assert.assertTrue((this.rule.getIntProperty(NonRuleWithAllPropertyTypes.singleInt) == 0 ? 1 : 0) != 0);
        this.rule.setProperties(NonRuleWithAllPropertyTypes.multiInt, new Object[]{new Integer(0), new Integer(1)});
        Assert.assertTrue((boolean)PropertyAccessorTest.areEqual(this.rule.getIntProperties(NonRuleWithAllPropertyTypes.multiInt), new int[]{0, 1}));
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testIntegersSingle() {
        this.rule.setProperties(NonRuleWithAllPropertyTypes.singleInt, new Object[]{new Integer(0), new Integer(1)});
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testIntegersMultiple() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.multiInt, (Object)new Integer(0));
    }

    @org.junit.Test
    public void testBooleans() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.singleBool, (Object)Boolean.FALSE);
        Assert.assertFalse((boolean)this.rule.getBooleanProperty(NonRuleWithAllPropertyTypes.singleBool));
        this.rule.setProperties(NonRuleWithAllPropertyTypes.multiBool, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        Assert.assertTrue((boolean)PropertyAccessorTest.areEqual(this.rule.getBooleanProperties(NonRuleWithAllPropertyTypes.multiBool), new boolean[]{true, false}));
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testBooleansSingle() {
        this.rule.setProperties(NonRuleWithAllPropertyTypes.singleBool, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testBooleansMultiple() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.multiBool, (Object)Boolean.TRUE);
    }

    @Ignore
    @org.junit.Test
    public void testFloats() throws ReportException {
    }

    @org.junit.Test
    public void testStrings() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.singleStr, (Object)"brian");
        Assert.assertEquals((Object)this.rule.getStringProperty(NonRuleWithAllPropertyTypes.singleStr), (Object)"brian");
        this.rule.setProperties(NonRuleWithAllPropertyTypes.multiStr, (Object[])new String[]{"hello", "world"});
        Assert.assertTrue((boolean)CollectionUtil.arraysAreEqual((Object)this.rule.getStringProperties(NonRuleWithAllPropertyTypes.multiStr), (Object)new String[]{"hello", "world"}));
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testStringsSingle() {
        this.rule.setProperties(NonRuleWithAllPropertyTypes.singleStr, (Object[])new String[]{"hello", "world"});
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testStringsMultiple() {
        this.rule.setProperty(NonRuleWithAllPropertyTypes.multiStr, (Object)"brian");
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$properties$PropertyAccessorTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$properties$PropertyAccessorTest = new PropertyAccessorTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

