/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.jsp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.jsp.ast.ASTElExpression;
import net.sourceforge.pmd.jsp.ast.ASTJspComment;
import net.sourceforge.pmd.jsp.ast.ASTJspDeclaration;
import net.sourceforge.pmd.jsp.ast.ASTJspDirective;
import net.sourceforge.pmd.jsp.ast.ASTJspDirectiveAttribute;
import net.sourceforge.pmd.jsp.ast.ASTJspExpression;
import net.sourceforge.pmd.jsp.ast.ASTJspExpressionInAttribute;
import net.sourceforge.pmd.jsp.ast.ASTJspScriptlet;
import net.sourceforge.pmd.jsp.ast.ASTValueBinding;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.jsp.ast.AbstractJspNodesTst;

public class JspPageStyleTest
extends AbstractJspNodesTst {
    private static final String JSP_COMMENT = "<html> <%-- some comment --%> </html>";
    private static final String JSP_DIRECTIVE = "<html> <%@ page language=\"java\" session='true'%> </html>";
    private static final String JSP_DECLARATION = "<html><%! String someString = \"s\"; %></html>";
    private static final String JSP_SCRIPTLET = "<html> <% someString = someString + \"suffix\"; %> </html>";
    private static final String JSP_EXPRESSION = "<html><head><title> <%= someString %> </title></head></html>";
    private static final String JSP_EXPRESSION_IN_ATTRIBUTE = "<html> <body> <p class='<%= style.getClass() %>'> Hello </p> </body> </html>";
    private static final String JSP_EL_EXPRESSION = "<html><title>Hello ${myBean.get(\"${ World }\") } .jsp</title></html>";
    private static final String JSP_EL_EXPRESSION_IN_ATTRIBUTE = "<html> <f:validator type=\"get('type').${myValidator.find(\"'jsp'\")}\" /> </html>";
    private static final String JSF_VALUE_BINDING = "<html> <body> <p class='#{myValidator.find(\"'jsf'\")}'> Hello </p> </body> </html>";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTValueBinding;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$jsp$ast$JspPageStyleTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspComment;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspExpressionInAttribute;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTElExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspScriptlet;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspDirectiveAttribute;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTJspDirective;

    @org.junit.Test
    public void testComment() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspComment;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspComment = new ASTJspComment[0].getClass().getComponentType();
        }
        Set comments = this.getNodes(clazz, JSP_COMMENT);
        Assert.assertEquals((String)"One comment expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)comments.size()));
        ASTJspComment comment = (ASTJspComment)comments.iterator().next();
        Assert.assertEquals((String)"Correct comment content expected!", (Object)"some comment", (Object)comment.getImage());
    }

    @org.junit.Test
    public void testDirective() {
        Set nodes = this.getNodes(null, JSP_DIRECTIVE);
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspDirective;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspDirective = new ASTJspDirective[0].getClass().getComponentType();
        }
        Set directives = this.getNodesOfType(clazz, nodes);
        Assert.assertEquals((String)"One directive expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)directives.size()));
        ASTJspDirective directive = (ASTJspDirective)directives.iterator().next();
        Assert.assertEquals((String)"Correct directive name expected!", (Object)"page", (Object)directive.getName());
        Class<?> clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTJspDirectiveAttribute;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTJspDirectiveAttribute = new ASTJspDirectiveAttribute[0].getClass().getComponentType();
        }
        Set directiveAttrs = this.getNodesOfType(clazz2, nodes);
        Assert.assertEquals((String)"Two directive attributes expected!", (Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)directiveAttrs.size()));
        ArrayList attrsList = new ArrayList(directiveAttrs);
        Collections.sort(attrsList, new Comparator<ASTJspDirectiveAttribute>(){

            @Override
            public int compare(ASTJspDirectiveAttribute arg0, ASTJspDirectiveAttribute arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }

            @Override
            public int compare(Object x0, Object x1) {
                return this.compare((ASTJspDirectiveAttribute)x0, (ASTJspDirectiveAttribute)x1);
            }
        });
        ASTJspDirectiveAttribute attr = (ASTJspDirectiveAttribute)attrsList.get(0);
        Assert.assertEquals((String)"Correct directive attribute name expected!", (Object)"language", (Object)attr.getName());
        Assert.assertEquals((String)"Correct directive attribute value expected!", (Object)"java", (Object)attr.getValue());
        attr = (ASTJspDirectiveAttribute)attrsList.get(1);
        Assert.assertEquals((String)"Correct directive attribute name expected!", (Object)"session", (Object)attr.getName());
        Assert.assertEquals((String)"Correct directive attribute value expected!", (Object)"true", (Object)attr.getValue());
    }

    @org.junit.Test
    public void testDeclaration() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspDeclaration = new ASTJspDeclaration[0].getClass().getComponentType();
        }
        Set declarations = this.getNodes(clazz, JSP_DECLARATION);
        Assert.assertEquals((String)"One declaration expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)declarations.size()));
        ASTJspDeclaration declaration = (ASTJspDeclaration)declarations.iterator().next();
        Assert.assertEquals((String)"Correct declaration content expected!", (Object)"String someString = \"s\";", (Object)declaration.getImage());
    }

    @org.junit.Test
    public void testScriptlet() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspScriptlet;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspScriptlet = new ASTJspScriptlet[0].getClass().getComponentType();
        }
        Set scriptlets = this.getNodes(clazz, JSP_SCRIPTLET);
        Assert.assertEquals((String)"One scriptlet expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)scriptlets.size()));
        ASTJspScriptlet scriptlet = (ASTJspScriptlet)scriptlets.iterator().next();
        Assert.assertEquals((String)"Correct scriptlet content expected!", (Object)"someString = someString + \"suffix\";", (Object)scriptlet.getImage());
    }

    @org.junit.Test
    public void testExpression() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspExpression = new ASTJspExpression[0].getClass().getComponentType();
        }
        Set expressions = this.getNodes(clazz, JSP_EXPRESSION);
        Assert.assertEquals((String)"One expression expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)expressions.size()));
        ASTJspExpression expression = (ASTJspExpression)expressions.iterator().next();
        Assert.assertEquals((String)"Correct expression content expected!", (Object)"someString", (Object)expression.getImage());
    }

    @org.junit.Test
    public void testExpressionInAttribute() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspExpressionInAttribute;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTJspExpressionInAttribute = new ASTJspExpressionInAttribute[0].getClass().getComponentType();
        }
        Set expressions = this.getNodes(clazz, JSP_EXPRESSION_IN_ATTRIBUTE);
        Assert.assertEquals((String)"One expression expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)expressions.size()));
        ASTJspExpressionInAttribute expression = (ASTJspExpressionInAttribute)expressions.iterator().next();
        Assert.assertEquals((String)"Correct expression content expected!", (Object)"style.getClass()", (Object)expression.getImage());
    }

    @org.junit.Test
    public void testElExpression() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTElExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTElExpression = new ASTElExpression[0].getClass().getComponentType();
        }
        Set expressions = this.getNodes(clazz, JSP_EL_EXPRESSION);
        Assert.assertEquals((String)"One expression expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)expressions.size()));
        ASTElExpression expression = (ASTElExpression)expressions.iterator().next();
        Assert.assertEquals((String)"Correct expression content expected!", (Object)"myBean.get(\"${ World }\")", (Object)expression.getImage());
    }

    @org.junit.Test
    public void testElExpressionInAttribute() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTElExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTElExpression = new ASTElExpression[0].getClass().getComponentType();
        }
        Set expressions = this.getNodes(clazz, JSP_EL_EXPRESSION_IN_ATTRIBUTE);
        Assert.assertEquals((String)"One expression expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)expressions.size()));
        ASTElExpression expression = (ASTElExpression)expressions.iterator().next();
        Assert.assertEquals((String)"Correct expression content expected!", (Object)"myValidator.find(\"'jsp'\")", (Object)expression.getImage());
    }

    @org.junit.Test
    public void testJsfValueBinding() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTValueBinding;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTValueBinding = new ASTValueBinding[0].getClass().getComponentType();
        }
        Set valueBindings = this.getNodes(clazz, JSF_VALUE_BINDING);
        Assert.assertEquals((String)"One value binding expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)valueBindings.size()));
        ASTValueBinding valueBinding = (ASTValueBinding)valueBindings.iterator().next();
        Assert.assertEquals((String)"Correct expression content expected!", (Object)"myValidator.find(\"'jsf'\")", (Object)valueBinding.getImage());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$jsp$ast$JspPageStyleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$jsp$ast$JspPageStyleTest = new JspPageStyleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

