/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.util.HashMap;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;

public class MatchAlgorithmTest {
    public static final String LINE_1 = "public class Foo { ";
    public static final String LINE_2 = " public void bar() {";
    public static final String LINE_3 = "  System.out.println(\"hello\");";
    public static final String LINE_4 = "  System.out.println(\"hello\");";
    public static final String LINE_5 = "  int i = 5";
    public static final String LINE_6 = "  System.out.print(\"hello\");";
    public static final String LINE_7 = " }";
    public static final String LINE_8 = "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$cpd$MatchAlgorithmTest;

    public static String getSampleCode() {
        return LINE_1 + PMD.EOL + LINE_2 + PMD.EOL + "  System.out.println(\"hello\");" + PMD.EOL + "  System.out.println(\"hello\");" + PMD.EOL + LINE_5 + PMD.EOL + LINE_6 + PMD.EOL + LINE_7 + PMD.EOL + LINE_8;
    }

    @org.junit.Test
    public void testSimple() throws Throwable {
        JavaTokenizer tokenizer = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader(MatchAlgorithmTest.getSampleCode(), "Foo.java"));
        Tokens tokens = new Tokens();
        TokenEntry.clearImages();
        tokenizer.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)41), (Object)Integer_.valueOf((int)tokens.size()));
        HashMap<String, SourceCode> codeMap = new HashMap<String, SourceCode>();
        codeMap.put("Foo.java", sourceCode);
        MatchAlgorithm matchAlgorithm = new MatchAlgorithm(codeMap, tokens, 5);
        matchAlgorithm.findMatches();
        Iterator matches = matchAlgorithm.matches();
        Match match = (Match)matches.next();
        Assert.assertFalse((boolean)matches.hasNext());
        Iterator marks = match.iterator();
        TokenEntry mark1 = (TokenEntry)marks.next();
        TokenEntry mark2 = (TokenEntry)marks.next();
        Assert.assertFalse((boolean)marks.hasNext());
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)mark1.getBeginLine()));
        Assert.assertEquals((Object)Integer_.valueOf((int)4), (Object)Integer_.valueOf((int)mark2.getBeginLine()));
        Assert.assertTrue(("Foo.java" == mark1.getTokenSrcID() && "Foo.java" == mark2.getTokenSrcID() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"  System.out.println(\"hello\");", (Object)match.getSourceCodeSlice());
    }

    @org.junit.Test
    public void testIgnore() throws Throwable {
        JavaTokenizer tokenizer = new JavaTokenizer();
        tokenizer.setIgnoreLiterals(true);
        tokenizer.setIgnoreIdentifiers(true);
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader(MatchAlgorithmTest.getSampleCode(), "Foo.java"));
        Tokens tokens = new Tokens();
        TokenEntry.clearImages();
        tokenizer.tokenize(sourceCode, tokens);
        HashMap<String, SourceCode> codeMap = new HashMap<String, SourceCode>();
        codeMap.put("Foo.java", sourceCode);
        MatchAlgorithm matchAlgorithm = new MatchAlgorithm(codeMap, tokens, 5);
        matchAlgorithm.findMatches();
        Iterator matches = matchAlgorithm.matches();
        Match match = (Match)matches.next();
        Assert.assertFalse((boolean)matches.hasNext());
        Iterator marks = match.iterator();
        marks.next();
        marks.next();
        marks.next();
        Assert.assertFalse((boolean)marks.hasNext());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$cpd$MatchAlgorithmTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$cpd$MatchAlgorithmTest = new MatchAlgorithmTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

