/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;

public class JavaTokensTokenizerTest {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$cpd$JavaTokensTokenizerTest;

    @org.junit.Test
    public void test1() throws Throwable {
        JavaTokenizer tokenizer = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader("public class Foo {}"));
        Tokens tokens = new Tokens();
        tokenizer.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)6), (Object)Integer_.valueOf((int)tokens.size()));
        Assert.assertEquals((Object)"public class Foo {}", (Object)sourceCode.getSlice(1, 1));
    }

    @org.junit.Test
    public void test2() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        String data = "public class Foo {" + PMD.EOL + "public void bar() {}" + PMD.EOL + "public void buz() {}" + PMD.EOL + "}";
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader(data));
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)("public class Foo {" + PMD.EOL + "public void bar() {}"), (Object)sourceCode.getSlice(1, 2));
    }

    @org.junit.Test
    public void testDiscardSemicolons() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader("public class Foo {private int x;}"));
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)9), (Object)Integer_.valueOf((int)tokens.size()));
    }

    @org.junit.Test
    public void testDiscardImports() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader("import java.io.File;" + PMD.EOL + "public class Foo {}"));
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)6), (Object)Integer_.valueOf((int)tokens.size()));
    }

    @org.junit.Test
    public void testDiscardPkgStmts() throws Throwable {
        JavaTokenizer t = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader("package foo.bar.baz;" + PMD.EOL + "public class Foo {}"));
        Tokens tokens = new Tokens();
        t.tokenize(sourceCode, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)6), (Object)Integer_.valueOf((int)tokens.size()));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$cpd$JavaTokensTokenizerTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$cpd$JavaTokensTokenizerTest = new JavaTokensTokenizerTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

