/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.cpd.FileReporter;
import net.sourceforge.pmd.cpd.ReportException;
import net.sourceforge.retroweaver.runtime.java.lang.Long_;
import org.junit.Assert;

public class FileReporterTest {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$cpd$FileReporterTest;

    @org.junit.Test(expected=NullPointerException.class)
    public void testCreation() {
        new FileReporter(null);
    }

    @org.junit.Test
    public void testEmptyReport() throws ReportException {
        File reportFile = new File("report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        fileReporter.report("");
        Assert.assertTrue((boolean)reportFile.exists());
        Assert.assertEquals((Object)Long_.valueOf((long)0L), (Object)Long_.valueOf((long)reportFile.length()));
        Assert.assertTrue((boolean)reportFile.delete());
    }

    @org.junit.Test
    public void testReport() throws ReportException, IOException {
        String testString = "first line\nsecond line";
        File reportFile = new File("report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        fileReporter.report(testString);
        Assert.assertEquals((Object)testString, (Object)this.readFile(reportFile));
        Assert.assertTrue((boolean)reportFile.delete());
    }

    @org.junit.Test(expected=ReportException.class)
    public void testInvalidFile() throws ReportException {
        File reportFile = new File("/invalid_folder/report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        fileReporter.report("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                line = reader.readLine();
                if (line == null) continue;
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$cpd$FileReporterTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$cpd$FileReporterTest = new FileReporterTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

