/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class MethodDeclTest
extends ParserTst {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$MethodDeclTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    @org.junit.Test
    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    @org.junit.Test
    public void testPrivate() throws Throwable {
        String[] access = new String[]{"private"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be private.", (boolean)amd.isPrivate());
    }

    @org.junit.Test
    public void testProtected() throws Throwable {
        String[] access = new String[]{"protected"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be protected.", (boolean)amd.isProtected());
    }

    @org.junit.Test
    public void testFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be final.", (boolean)amd.isFinal());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    @org.junit.Test
    public void testSynchronized() throws Throwable {
        String[] access = new String[]{"public", "synchronized"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be synchronized.", (boolean)amd.isSynchronized());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    @org.junit.Test
    public void testAbstract() throws Throwable {
        String[] access = new String[]{"public", "abstract"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be abstract.", (boolean)amd.isAbstract());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    @org.junit.Test
    public void testNative() throws Throwable {
        String[] access = new String[]{"private", "native"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be native.", (boolean)amd.isNative());
        Assert.assertTrue((String)"Expecting method to be private.", (boolean)amd.isPrivate());
    }

    @org.junit.Test
    public void testStrict() throws Throwable {
        String[] access = new String[]{"public", "strictfp"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be strict.", (boolean)amd.isStrictfp());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public ASTMethodDeclaration getMethodDecl(String[] access) throws Throwable {
        String javaCode = "public class Test { ";
        for (int i = 0; i < access.length; ++i) {
            javaCode = javaCode + access[i] + " ";
        }
        javaCode = javaCode + " void stuff() { } }";
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        Set methods = this.getNodes(clazz, javaCode);
        Assert.assertEquals((String)"Wrong number of methods", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)methods.size()));
        Iterator i = methods.iterator();
        return (ASTMethodDeclaration)i.next();
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$MethodDeclTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$MethodDeclTest = new MethodDeclTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

