/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class ClassDeclTest
extends ParserTst {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$ClassDeclTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;

    @org.junit.Test
    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTClassOrInterfaceDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, true, false, false, false);
    }

    @org.junit.Test
    public void testAbstract() throws Throwable {
        String[] access = new String[]{"abstract"};
        ASTClassOrInterfaceDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, true, false, false);
    }

    @org.junit.Test
    public void testFinal() throws Throwable {
        String[] access = new String[]{"final"};
        ASTClassOrInterfaceDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, false, true, false);
    }

    @org.junit.Test
    public void testStrict() throws Throwable {
        String[] access = new String[]{"strictfp"};
        ASTClassOrInterfaceDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, false, false, true);
    }

    @org.junit.Test
    public void testPublicFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTClassOrInterfaceDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, true, false, true, false);
    }

    public void verifyFlags(ASTClassOrInterfaceDeclaration acd, boolean bPublic, boolean bAbstract, boolean bFinal, boolean bStrict) {
        Assert.assertEquals((String)"Public: ", (Object)Boolean_.valueOf((boolean)bPublic), (Object)Boolean_.valueOf((boolean)acd.isPublic()));
        Assert.assertEquals((String)"Abstract: ", (Object)Boolean_.valueOf((boolean)bAbstract), (Object)Boolean_.valueOf((boolean)acd.isAbstract()));
        Assert.assertEquals((String)"Final: ", (Object)Boolean_.valueOf((boolean)bFinal), (Object)Boolean_.valueOf((boolean)acd.isFinal()));
        Assert.assertEquals((String)"Strict: ", (Object)Boolean_.valueOf((boolean)bStrict), (Object)Boolean_.valueOf((boolean)acd.isStrictfp()));
    }

    public ASTClassOrInterfaceDeclaration getClassDecl(String[] access) throws Throwable {
        String javaCode = "";
        for (int i = 0; i < access.length; ++i) {
            javaCode = javaCode + access[i] + " ";
        }
        javaCode = javaCode + " class Test { } ";
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        Set classes = this.getNodes(clazz, javaCode);
        Assert.assertEquals((String)"Wrong number of classes", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)classes.size()));
        Iterator i = classes.iterator();
        return (ASTClassOrInterfaceDeclaration)i.next();
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$ClassDeclTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$ClassDeclTest = new ClassDeclTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

